/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model.text;

import java.io.IOException;

import javax.ide.model.Document;
import javax.ide.model.spi.TextDocumentImpl;

/**
 *  The <CODE>TextDocument</CODE> class.
 */
public class TextDocument extends Document 
{
  private TextDocumentImpl getTextDocumentImpl()
  {
    return (TextDocumentImpl)getElementImpl();
  }

  /**
   * Fetches the document contents. This calls opens the document and loads 
   * its contents. The document instance returned lives while clients refer
   * to it. Once a document instance is not referred by clients it may be
   * garbage collected at any time.
   *
   * @return the {@link TextModel} containing the document text.
   * @exception IOException if the document cannot be opened.
   */
  public final TextModel getTextModel()
    throws IOException
  {
    return getTextDocumentImpl().getTextModel();
  }
}
