/*
 * @(#)AssertStatementT.java
 */

package javax.ide.model.java.source.tree;

/**
 * An assert statement. JLS3 14.10. An assert statement has a
 * conditional expression and an optional detail message expression.
 * Here are some examples: <p/>
 *
 * <pre>
 *   assert enabled == true;
 *   assert(enabled == true);
 *   assert enabled == true: "Not enabled";
 * </pre>
 * 
 * If there is a second expression and the condition evaluates to
 * false, then the second expression is evaluated and then converted
 * to a String used to create a new AssertionError.
 *
 * @author Andy Yu
 * */
public interface AssertStatementT
  extends SimpleStatementT
{
  /**
   * Valid for "assert" statements.
   * Syntax is "assert boolean-expr: output-expr;".
   *
   * @return the output expression. Null if none was declared or if
   * this is not an assert statement.
   */
  public ExpressionT getOutputExpression();

}
