/*
 * @(#)SourcePosition.java
 */

package javax.ide.model.java.source;

import java.net.URI;

/**
 * Represents a position in a source file.
 *
 * @author Andy Yu
 */
public interface SourcePosition
{
  // ----------------------------------------------------------------------

  /**
   * Gets the column number of this position.
   *
   * @return The column number of this position.
   */
  public int column();

  /**
   * Gets the line number of this position.
   *
   * @return The line number of this position.
   */
  public int line();

  /**
   * Gets the file of this position.
   *
   * @return The URI for the file of this position.
   */
  public URI file();
}
