/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

import javax.ide.util.MetaClass;

/**
 * Records information defining the listener class to be instantiated 
 * when an event on the target object occurs.
 * The information used to initialize this class comes from an 
 * extension manifest editor-hook section.
 */
public final class ListenerInfo 
{
  private MetaClass _listenerClass;
  private String    _sourceID;

  /**
   * Constructor.
   */
  public ListenerInfo() 
  {
  }

  /**
   * Get the listener class. An instance of this class will be created 
   * when the source object needs to notify listeners of current events.
   *
   * @return The listener class {@link MetaClass}
   */
  public MetaClass getListenerClass()
  {
    return _listenerClass;
  }

  /**
   * Set the listener class. An instance of this class will be created 
   * when the source object needs to notify listeners of current events.
   *
   * @param listenerClass The listener class.
   */
  public void setListenerClass( MetaClass listenerClass )
  {
    _listenerClass = listenerClass;
  }

  /**
   * Get the ID of the event source. 
   *
   * @return The source unique identifier.
   */
  public String getSourceID()
  {
    return _sourceID;
  }

  /**
   * Get the ID of the event source. 
   *
   * @param id The source unique identifier.
   */
  public void setSourceID( String id )
  {
    _sourceID = id;
  }
}
