/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;

/**
 * The element visitor factory is used to create or retrieve visitors for
 * specific xml elements while traversing xml.
 */
public interface ElementVisitorFactory 
{
  /**
   * Get a suitable visitor for the specified element name.
   * 
   * @param name a qualified element name.
   * @return a visitor suitable for this element, or null.
   * @throws UnrecognizedElementException if the factory does not 
   *    recognize the element and this should be raised as an error.
   */
  ElementVisitor getVisitor( ElementName name )
    throws UnrecognizedElementException;
}
