/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ide.util.AddinPolicyUtils;

public class IndexThreadFactory
implements ThreadFactory {
    private final String baseName;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexThreadFactory(String baseName) {
        this.baseName = baseName + "-thread-";
        SecurityManager s = System.getSecurityManager();
        boolean wasWarn = AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)false);
        try {
            this.threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        finally {
            AddinPolicyUtils.setWarnWhenCreatingThreads((boolean)wasWarn);
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.threadGroup, r, this.baseName + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

