/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class AnnotationTextLayoutPanel
extends JPanel {
    private JLabel mlinespacingLabel = new JLabel();
    private JTextField mlinespacingTxt = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel label_Filler = new JLabel();
    private JLabel hallignLabel = new JLabel();
    private JComboBox hallignCombo = new JComboBox();
    private JLabel vallignLabel = new JLabel();
    private JComboBox vallignCombo = new JComboBox();
    private JLabel mlinejustLabel = new JLabel();
    private JComboBox mlinejustCombo = new JComboBox();

    public AnnotationTextLayoutPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(319, 128));
        this.setPreferredSize(new Dimension(275, 335));
        this.add((Component)this.label_Filler, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.mlinespacingLabel.setText(MessagesBundle.getMessage("Label_multiline_spacing"));
        this.add((Component)this.mlinespacingLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.mlinespacingTxt.setText("0");
        this.add((Component)this.mlinespacingTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.hallignLabel.setText(MessagesBundle.getMessage("Label_horizontal_alignment"));
        this.hallignCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.hallignCombo.addItem("START");
        this.hallignCombo.addItem("CENTER");
        this.hallignCombo.addItem("END");
        this.add((Component)this.hallignLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.hallignCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.vallignLabel.setText(MessagesBundle.getMessage("Label_vertical_alignment"));
        this.vallignCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.vallignCombo.addItem("TOP");
        this.vallignCombo.addItem("CENTER");
        this.vallignCombo.addItem("BASELINE");
        this.vallignCombo.addItem("BOTTOM");
        this.add((Component)this.vallignLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.vallignCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.mlinejustLabel.setText(MessagesBundle.getMessage("Label_multiline_justification"));
        this.mlinejustCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.mlinejustCombo.addItem("LEFT");
        this.mlinejustCombo.addItem("CENTER");
        this.mlinejustCombo.addItem("RIGHT");
        this.add((Component)this.mlinejustLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.mlinejustCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.mlinespacingTxt.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void setMultilineSpacing(float spacing) {
        NumberFormat nf = NumberFormat.getInstance();
        if (spacing < 0.0f) {
            this.mlinespacingTxt.setText("0");
        } else {
            this.mlinespacingTxt.setText(nf.format(spacing));
        }
    }

    public float getMultilineSpacing() {
        String text = this.mlinespacingTxt.getText();
        if (text == null || text.length() == 0) {
            return 0.0f;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            float spacing = nf.parse(text).floatValue();
            if (spacing < 0.0f) {
                return 0.0f;
            }
            return spacing;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getHorizontalAllignment() {
        return this.hallignCombo.getSelectedItem().toString();
    }

    public void setHorizontalAllignment(String allignment) {
        if (allignment == null) {
            return;
        }
        this.hallignCombo.setSelectedItem(allignment.toUpperCase());
    }

    public String getVerticalAllignment() {
        return this.vallignCombo.getSelectedItem().toString();
    }

    public void setVerticalAllignment(String allignment) {
        if (allignment == null) {
            return;
        }
        this.vallignCombo.setSelectedItem(allignment.toUpperCase());
    }

    public String getMultilineJustification() {
        return this.mlinejustCombo.getSelectedItem().toString();
    }

    public void setMultilineJustification(String justification) {
        if (justification == null) {
            return;
        }
        this.mlinejustCombo.setSelectedItem(justification.toUpperCase());
    }

    public void allowChanges(boolean enable) {
        this.mlinespacingTxt.setEnabled(enable);
        this.hallignCombo.setEnabled(enable);
        this.vallignCombo.setEnabled(enable);
        this.mlinejustCombo.setEnabled(enable);
    }
}

