/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.EventObject;
import java.util.logging.Logger;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.util.JGeometrySegmentUtil;
import oracle.spatial.geometry.JGeometry;

public class VertexAddTool
extends BasicTool {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    ActiveFeaturesLayer featureLayer = null;
    JGeometrySegmentPoint snapInterPoint = null;
    private RTreeIndex sptIndex = null;

    public VertexAddTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Add vertex");
    }

    @Override
    public void clear() {
        this.snapInterPoint = null;
        this.sptIndex = null;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            switch (id) {
                case 500: {
                    if (e.getButton() != 1) break;
                    this.mouseClicked(e);
                    propagate = false;
                    break;
                }
                case 503: {
                    this.mouseMoved(e);
                }
            }
        }
        return propagate;
    }

    protected void mouseClicked(MouseEvent evt) {
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        GeoObject activeFeature = this.featureLayer.getActiveFeature();
        if (targetLayer == null || activeFeature == null || this.snapInterPoint == null) {
            return;
        }
        double wcTolerance = TransformUtils.getWCTolerance(this.snapInterPoint.getPoint(), 3, this.canvas.getViewportTransform());
        if (targetLayer instanceof GeometrySetLayer) {
            GeometryFeature selectedFeature = (GeometryFeature)activeFeature;
            GeometrySetLayer gl = (GeometrySetLayer)targetLayer;
            JGeometrySegmentPoint[] linkSeg = null;
            linkSeg = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPointOfFeatures(this.snapInterPoint.getPoint(), wcTolerance, false, false, false, false);
            if (linkSeg == null || linkSeg.length == 0) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
            String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
            try {
                gl.addVertexes(key, linkSeg);
            }
            catch (Exception ex) {
                log.severe("(VertexAddTool:mouseClicked) " + ex.getMessage());
            }
        } else if (targetLayer instanceof TopologyPrimitiveLayer) {
            try {
                GeometryFeature selectedFeature = (GeometryFeature)activeFeature;
                int edgeId = Integer.parseInt(selectedFeature.getKey().toString());
                JGeometry change = JGeometryUtil.addVertex((JGeometry)selectedFeature.getSpatialAttribute(), (JGeometrySegmentPoint)this.snapInterPoint);
                ((TopologyPrimitiveLayer)targetLayer).changeEdgeGeometry(edgeId, change);
                selectedFeature.setSpatialAttribute(change);
            }
            catch (Exception ex) {
                log.severe("(VertexAddTool:mouseClicked) " + ex.getMessage());
            }
        }
        this.clear();
        this.featureLayer.setSnapPoint(null);
    }

    protected void mouseMoved(MouseEvent evt) {
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        GeoObject activeFeature = this.featureLayer.getActiveFeature();
        if (targetLayer == null || activeFeature == null) {
            return;
        }
        try {
            Point2D.Double center = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), center);
            double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
            if (targetLayer instanceof GeometrySetLayer) {
                GeometryFeature selectedFeature = (GeometryFeature)activeFeature;
                GeometrySetLayer gl = (GeometrySetLayer)targetLayer;
                String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                this.snapInterPoint = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(key, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false);
            } else if (targetLayer instanceof TopologyPrimitiveLayer) {
                JGeometry geom = ((GeometryFeature)activeFeature).getSpatialAttribute();
                if (this.sptIndex == null) {
                    this.sptIndex = JGeometrySegmentUtil.buildSegmentTree(geom);
                }
                this.snapInterPoint = JGeometrySegmentUtil.getSegmentPoint(geom, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false, this.sptIndex, ((GeometryFeature)activeFeature).getKey().toString());
            }
            if (this.snapInterPoint == null || this.snapInterPoint.getPointLocation() != 2) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            this.featureLayer.setSnapPoint(this.snapInterPoint.getPoint());
        }
        catch (Exception ex) {
            this.clear();
            this.featureLayer.setSnapPoint(null);
        }
    }

    public Layer getActiveFeatureLayer() {
        return this.featureLayer;
    }

    public void setFeatureLayer(ActiveFeaturesLayer featureLayer) {
        this.featureLayer = featureLayer;
    }
}

