/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.ui.DetailView;

public final class TabbedDetailView
implements DetailView {
    private JPanel content = new JPanel(new BorderLayout());
    private JComponent currentViewComponent = new JLabel("Empty");
    private DefaultListModel model = new DefaultListModel();
    private CustomTab tabs = new CustomTab((ListModel)this.model, 3);
    private List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private InsightItem selItem;
    private CompletionContext completionContext;
    public final String PROPERTY_TAB_CHANGE = "tabChange";

    public TabbedDetailView() {
        this.content.setOpaque(true);
        this.content.setBackground(Color.WHITE);
        this.tabs.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TabbedDetailView.this.updateSelection();
            }
        });
        this.content.add((Component)this.tabs, "South");
        this.content.setBackground(Color.WHITE);
    }

    public void addTab(DetailView view, String title, boolean isDefault) {
        DefaultCustomTabPage page = new DefaultCustomTabPage(null, title, (Object)view);
        this.model.addElement(page);
        if (this.model.getSize() == 1 || isDefault) {
            this.tabs.setSelectedPage(this.model.getSize() - 1);
        }
    }

    private void updateSelection() {
        Window w;
        this.content.remove(this.currentViewComponent);
        DefaultCustomTabPage page = (DefaultCustomTabPage)this.model.get(this.tabs.getSelectedPage());
        DetailView view = (DetailView)page.getUserObject();
        view.itemSelected(this.completionContext, this.selItem);
        this.currentViewComponent = view.getDetailComponent();
        if (this.currentViewComponent != null) {
            this.currentViewComponent.setBorder(null);
            this.content.add((Component)this.currentViewComponent, "Center");
        }
        if ((w = SwingUtilities.getWindowAncestor(this.content)) != null) {
            w.pack();
            w.setSize(w.getWidth() + 4, w.getHeight() + 2);
        }
        this.firePropertyChange(new PropertyChangeEvent(this, "tabChange", null, view));
    }

    @Override
    public JComponent getDetailComponent() {
        return this.content;
    }

    public void itemSelected(CompletionContext completionContext, InsightItem item) {
        this.selItem = item;
        this.completionContext = completionContext;
        DefaultCustomTabPage page = (DefaultCustomTabPage)this.model.get(this.tabs.getSelectedPage());
        DetailView view = (DetailView)page.getUserObject();
        view.itemSelected(completionContext, item);
    }

    @Override
    public void shown(CompletionContext completionContext) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this.model.get(i);
            DetailView view = (DetailView)page.getUserObject();
            view.shown(completionContext);
        }
    }

    @Override
    public void hidden(CompletionContext completionContext) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this.model.get(i);
            DetailView view = (DetailView)page.getUserObject();
            view.hidden(completionContext);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(propertyChangeEvent);
        }
    }
}

