/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.insight.InsightAdapter;
import oracle.ide.insight.InsightContext;
import oracle.ide.insight.InsightProvider;
import oracle.ide.insight.completion.CompletionController;
import oracle.ide.insight.completion.CompletionModel;
import oracle.ide.insight.completion.CompletionMultiProvider;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionSupport;

public final class CompletionContext<S extends CompletionSupport>
extends InsightContext<S> {
    private final InsightProvider provider;
    private final Invoked invoked;
    private final CompletionMultiProvider multiProvider;

    public CompletionContext(S support, Invoked invoked, CompletionMultiProvider multiInsightController) {
        super(support);
        this.provider = multiInsightController.getCurrentProvider();
        this.invoked = invoked;
        this.multiProvider = multiInsightController;
    }

    public CompletionContext(CompletionContext<S> completionContext) {
        super(completionContext.getSupport());
        this.provider = completionContext.getMultiProvider().getCurrentProvider();
        this.invoked = completionContext.invoked;
        this.multiProvider = completionContext.multiProvider;
    }

    public CompletionContext(S support, Invoked invoked, CompletionProvider provider) {
        super(support);
        this.provider = provider;
        this.invoked = invoked;
        ArrayList<CompletionProvider> providerList = new ArrayList<CompletionProvider>();
        providerList.add(provider);
        this.multiProvider = new CompletionMultiProvider(this.getController(), providerList);
    }

    public Invoked getInvoked() {
        return this.invoked;
    }

    public CompletionModel getModel() {
        return this.getController().getCurrentModel();
    }

    public CompletionProvider getProvider() {
        return this.multiProvider.getCurrentProvider();
    }

    public CompletionMultiProvider getMultiProvider() {
        return this.multiProvider;
    }

    public InsightAdapter getAdapter() {
        return ((CompletionSupport)this.getSupport()).getAdapter();
    }

    public Context getContext() {
        return ((CompletionSupport)this.getSupport()).getContext();
    }

    public void updateInsight() {
        this.getController().triggerUpdate();
    }

    public CompletionController getController() {
        return ((CompletionSupport)this.getSupport()).getInsightController();
    }

    public void triggerToolTipInsight() {
        this.getController().triggerToolTipInsight();
    }

    public static enum Invoked {
        MANUAL,
        AUTO;

    }
}

