/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.UndoableEditCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightAdapter;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightSupport;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.language.LanguageSupport;

public final class EditorAdapter<C extends InsightController>
implements InsightAdapter<BasicEditorPane, C> {
    private InsightSupport<BasicEditorPane, C> insightSupport;
    private List<InsightActionListener> listeners = new CopyOnWriteArrayList<InsightActionListener>();
    private EditorL editorL = new EditorL();
    private static final double listenerWeight = 1.0;

    @Override
    public void install(InsightSupport<BasicEditorPane, C> insightSupport) {
        this.insightSupport = insightSupport;
        this.getTextComponent().addPreActionInvoker((ActionPreInvoker)this.editorL, 1.0);
    }

    @Override
    public void deinstall() {
        this.getTextComponent().removePreActionInvoker((ActionPreInvoker)this.editorL, 1.0);
        this.insightSupport = null;
    }

    @Override
    public InsightSupport<BasicEditorPane, C> getInsightSuport() {
        return this.insightSupport;
    }

    @Override
    public BasicEditorPane getTextComponent() {
        return this.insightSupport.getTextComponent();
    }

    @Override
    public Integer getState() {
        return ((BasicDocument)this.getTextComponent().getDocument()).getTextBuffer().getChangeId();
    }

    @Override
    public boolean isEditable() {
        return this.getTextComponent().isEditable();
    }

    @Override
    public void makeEditable() {
        this.getTextComponent().makeEditable();
    }

    @Override
    public void showFeedback(final String message) {
        final BasicEditorPane editor = this.getTextComponent();
        Runnable showFeedback = new Runnable(){

            @Override
            public void run() {
                FeedbackManager feedbackManager = editor.getFeedbackManager();
                if (feedbackManager != null) {
                    feedbackManager.showFeedback(editor, message, 5000);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            showFeedback.run();
        } else {
            SwingUtilities.invokeLater(showFeedback);
        }
    }

    public LanguageSupport getLanguageSupport() {
        return ((BasicDocument)this.getTextComponent().getDocument()).getLanguageSupport();
    }

    public TextBuffer getTextBuffer() {
        return ((BasicDocument)this.getTextComponent().getDocument()).getTextBuffer();
    }

    @Override
    public int getOffset() {
        return this.getTextComponent().getCaretPosition();
    }

    @Override
    public void beginEdit(EditDescriptor editDescriptor) {
        this.getTextComponent().beginEdit(editDescriptor);
    }

    @Override
    public void endEdit() {
        this.getTextComponent().endEdit(false);
    }

    @Override
    public void recordUndo(String undoDescription, Context context, UndoableEdit edit) {
        UndoableEditCommand command = new UndoableEditCommand(undoDescription, context);
        command.addEdit(edit);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            commandProcessor.invoke((Command)command);
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void addInsightActionListener(InsightActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    @Override
    public void removeInsightActionListener(InsightActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private class EditorL
    implements ActionPreInvoker {
        private EditorL() {
        }

        public boolean invokeAction(String actionKey) {
            InsightActionListener.Action action = null;
            if (actionKey.equals("cancel")) {
                action = InsightActionListener.Action.CANCEL;
            }
            if (EditorAdapter.this.insightSupport.getInsightController().getState() == InsightController.State.SHOWING) {
                if (actionKey.equals("completion-insight")) {
                    action = InsightActionListener.Action.INVOKE;
                } else if (actionKey.equals("cancel")) {
                    action = InsightActionListener.Action.CANCEL;
                } else if (actionKey.equals("insert-break")) {
                    action = InsightActionListener.Action.ENTER;
                } else if (actionKey.equals("caret-up")) {
                    action = InsightActionListener.Action.UP;
                } else if (actionKey.equals("caret-down")) {
                    action = InsightActionListener.Action.DOWN;
                } else if (actionKey.equals("show-doc-popup")) {
                    action = InsightActionListener.Action.SHOW_DOC;
                } else if (actionKey.equals("scroll-line-up")) {
                    action = InsightActionListener.Action.SCROLL_DOC_UP;
                } else if (actionKey.equals("scroll-line-down")) {
                    action = InsightActionListener.Action.SCROLL_DOC_DOWN;
                } else if (actionKey.equals("page-up")) {
                    action = InsightActionListener.Action.PAGE_UP;
                } else if (actionKey.equals("page-down")) {
                    action = InsightActionListener.Action.PAGE_DOWN;
                } else if (actionKey.equals("insert-tab")) {
                    action = InsightActionListener.Action.TAB;
                }
            }
            if (action != null) {
                boolean handled = false;
                BasicEditorPane editor = EditorAdapter.this.getTextComponent();
                for (int i = EditorAdapter.this.listeners.size() - 1; i >= 0; --i) {
                    InsightActionListener l = (InsightActionListener)EditorAdapter.this.listeners.get(i);
                    handled |= l.insightActionPerformed(action, editor);
                }
                return handled;
            }
            return false;
        }
    }
}

