/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.objects.impl;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.Maps;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.common.util.Unsupported;
import oracle.dbtools.objects.ContainerNode;
import oracle.dbtools.objects.ContainerType;
import oracle.dbtools.objects.ImmutableBean;
import oracle.dbtools.objects.IterableContainer;
import oracle.dbtools.objects.MapContainer;
import oracle.dbtools.objects.ObjectGraphs;
import oracle.dbtools.objects.SerializationPolicy;
import oracle.dbtools.objects.Serialize;
import oracle.dbtools.plugin.api.collections.MultiMap;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class ObjectGraphsProvider
implements ObjectGraphs {
    private final Maps maps;
    private static final IgnoredMethods IGNORED_METHODS = new IgnoredMethods();

    @Inject
    public ObjectGraphsProvider(Maps maps) {
        this.maps = maps;
    }

    @Override
    public Object adapt(Object objectGraph) {
        if (objectGraph == null) {
            return null;
        }
        if (this.isScalar(objectGraph) || objectGraph instanceof ContainerNode) {
            return objectGraph;
        }
        if (this.isIterable(objectGraph)) {
            return this.adaptIterable(objectGraph);
        }
        if (this.isMap(objectGraph)) {
            return this.adaptMap(objectGraph);
        }
        throw new IllegalArgumentException(objectGraph.getClass().toString());
    }

    @Override
    public boolean isLegal(Class<?> type) {
        return this.isScalar(type) || this.isIterable(type) || this.isMap(type);
    }

    private Object adaptIterable(Object object) {
        Iterable target = null;
        if (this.isArray(object)) {
            target = this.iterableArray(object);
        } else {
            if (object instanceof IterableContainer) {
                return object;
            }
            target = (Iterable)object;
        }
        return new IterableAdapter(target);
    }

    private Object adaptMap(Object object) {
        ImmutableMap target = null;
        if (object instanceof MapContainer) {
            return object;
        }
        if (object instanceof KeyedLookup) {
            target = (ImmutableMap)object;
        } else if (object instanceof Map) {
            target = this.maps.map((Map)object);
        } else if (object instanceof MultiMap) {
            MultiMap multiMap = (MultiMap)object;
            target = this.maps.map(multiMap.map());
        } else {
            if (this.isImmutableBean(object)) {
                return this.asMap((ImmutableBean)object);
            }
            throw new IllegalArgumentException();
        }
        return new MapAdapter(target);
    }

    private MapContainer asMap(ImmutableBean bean) {
        ImmutableMap.Builder<String, Object> properties = this.maps.builder().ordering(Ordering.SORTED);
        for (Method m : bean.getClass().getMethods()) {
            SerializationPolicy policy;
            Class<?> returnType = m.getReturnType();
            if (IGNORED_METHODS.ignore(m) || !this.isLegal(returnType) || this.objectMethod(m) || SerializationPolicy.NEVER == (policy = this.serializable(m))) continue;
            try {
                m.setAccessible(true);
                String name = m.getName();
                Object value = m.invoke((Object)bean, new Object[0]);
                if (value == null && SerializationPolicy.ALWAYS != policy) continue;
                properties.add(name, value);
            }
            catch (Throwable t) {
                throw UnrecoverableException.unrecoverable(t);
            }
        }
        return new MapAdapter(properties.build());
    }

    private boolean isArray(Class<?> type) {
        return type.isArray();
    }

    private boolean isArray(Object object) {
        return this.isArray(object.getClass());
    }

    private boolean isImmutableBean(Class<?> type) {
        return ImmutableBean.class.isAssignableFrom(type);
    }

    private boolean isImmutableBean(Object instance) {
        if (instance != null) {
            return this.isImmutableBean(instance.getClass());
        }
        return false;
    }

    private boolean isIterable(Class<?> type) {
        return this.isArray(type) || Iterable.class.isAssignableFrom(type);
    }

    private boolean isIterable(Object object) {
        return this.isIterable(object.getClass());
    }

    private boolean isMap(Class<?> type) {
        return Map.class.isAssignableFrom(type) || KeyedLookup.class.isAssignableFrom(type) || MultiMap.class.isAssignableFrom(type) || this.isImmutableBean(type);
    }

    private boolean isMap(Object object) {
        return this.isMap(object.getClass());
    }

    private boolean isScalar(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) && !Character.class.isAssignableFrom(type) && !Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Readable.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type);
    }

    private boolean isScalar(Object object) {
        return this.isScalar(object.getClass());
    }

    private Iterable<?> iterableArray(Object object) {
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        int length = Array.getLength(object);
        Object[] converted = new Object[length];
        for (int i = 0; i < length; ++i) {
            converted[i] = Array.get(object, i);
        }
        return Arrays.asList(converted);
    }

    private boolean objectMethod(Method m) {
        try {
            Object.class.getDeclaredMethod(m.getName(), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private SerializationPolicy serializable(Method m) {
        SerializationPolicy policy = SerializationPolicy.ALWAYS;
        Class<?> type = m.getDeclaringClass();
        Serialize serialize = type.getAnnotation(Serialize.class);
        if (serialize == null) {
            serialize = m.getAnnotation(Serialize.class);
        }
        if (serialize != null) {
            policy = serialize.value();
        }
        return policy;
    }

    private class MapAdapter
    implements MapContainer {
        private final ImmutableMap<String, Object> elements;

        public MapAdapter(KeyedLookup<?, ?> target) {
            ImmutableMap.Builder<String, Object> elements = ObjectGraphsProvider.this.maps.builder();
            for (Map.Entry<?, ?> entry : target.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                elements.add(key.toString(), ObjectGraphsProvider.this.adapt(value));
            }
            this.elements = elements.build();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.elements.containsKey(key.toString());
        }

        public boolean equals(Object obj) {
            return this.elements.equals(obj);
        }

        @Override
        public Object get(CharSequence key) {
            return this.elements.get(key.toString());
        }

        @Override
        public Object get(Object key) {
            return this.get(key.toString());
        }

        public int hashCode() {
            return this.elements.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.elements.keySet();
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        public String toString() {
            return this.elements.toString();
        }

        @Override
        public ContainerType type() {
            return ContainerType.MAP;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return null;
        }
    }

    private class IterableAdapter
    implements IterableContainer {
        private final int size;
        private final Iterable<?> target;

        public IterableAdapter(Iterable<?> target) {
            this.target = target;
            this.size = Iterables.size(target);
        }

        public Iterable<Object> elements() {
            return new ElementIterable(this.target);
        }

        public boolean equals(Object obj) {
            return this.target.equals(obj);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.size <= 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        public String toString() {
            return this.target.toString();
        }

        @Override
        public ContainerType type() {
            return ContainerType.ITERABLE;
        }
    }

    private static class IgnoredMethods {
        private final List<String> objectMethods = new ArrayList<String>();

        public IgnoredMethods() {
            for (Method m : Object.class.getDeclaredMethods()) {
                if (!this.hasNoParameters(m) || this.isVoid(m)) continue;
                this.objectMethods.add(m.getName());
            }
        }

        boolean ignore(Method m) {
            return !this.hasNoParameters(m) || this.isVoid(m) || this.objectMethods.contains(m.getName());
        }

        private boolean hasNoParameters(Method m) {
            return m.getParameterTypes().length == 0;
        }

        private boolean isVoid(Method m) {
            return Void.TYPE.equals(m.getReturnType());
        }
    }

    private class ElementIterable
    implements Iterable<Object> {
        private final Iterable<?> target;

        public ElementIterable(Iterable<?> target) {
            this.target = target;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ContainerIterator(this.target.iterator());
        }
    }

    private class ContainerIterator
    implements Iterator<Object> {
        private final Iterator<?> target;

        ContainerIterator(Iterator<?> target) {
            this.target = target;
        }

        public boolean equals(Object obj) {
            return this.target.equals(obj);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean hasNext() {
            return this.target.hasNext();
        }

        @Override
        public Object next() {
            return this.target.next();
        }

        @Override
        public void remove() {
            Unsupported.unsupported();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

