/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.CommonMessages;
import oracle.dbtools.common.TranslatableExceptionBase;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URLEncoding;

public abstract class URIs {
    private static final String[] ESCAPED = new String[]{"%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60"};
    private static final String FILE_SCHEME = "file";
    private static final String JAR_SCHEME = "jar";
    private static final String JARCL_SCHEME = "jarcl";
    private static final String PATH_SEPARATOR = "/";
    private static final String[] UNWISE = new String[]{"{", "}", "|", "\\", "^", "[", "]", "`"};
    private static final String ZIP_SCHEME = "zip";

    private URIs() {
    }

    public static URI create(String text) throws IllegalURIException {
        if (text == null) {
            return null;
        }
        try {
            String escaped = URIs.normalize(text);
            URI uri = new URI(escaped);
            return uri;
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri(e);
        }
    }

    public static boolean exists(URI uri) {
        return URIs.status(uri) != Status.DOES_NOT_EXIST;
    }

    public static IllegalURIException illegalUri(URISyntaxException e) {
        throw new IllegalURIException(e);
    }

    public static InputStream inputStream(URI uri) throws IOException {
        if (FILE_SCHEME.equals(uri.getScheme())) {
            return Files.inputStream(Files.file(uri));
        }
        URL url = uri.toURL();
        return url.openStream();
    }

    public static boolean isFolder(URI uri) {
        if (uri != null) {
            if (uri.isOpaque()) {
                return uri.getSchemeSpecificPart().endsWith(PATH_SEPARATOR);
            }
            return uri.getPath().endsWith(PATH_SEPARATOR);
        }
        return false;
    }

    public static String path(URI uri) {
        if (URIs.isJarUri(uri)) {
            Pair<URI, URI> parsed = URIs.parseJarUri(uri);
            return parsed.second().getPath();
        }
        return uri.getPath();
    }

    public static String pathInfo(String contextPath, String uri) {
        return URIs.pathInfo(contextPath, URIs.create(uri));
    }

    public static String pathInfo(String contextPath, URI uri) {
        String path;
        if (uri != null && !uri.isOpaque() && (path = uri.getRawPath()).startsWith(contextPath)) {
            path = path.substring(contextPath.length());
            return URLEncoding.decode(path);
        }
        return null;
    }

    public static String relativeTo(String base, String path) {
        return URIs.relativeTo(URIs.create(base), URIs.create(path));
    }

    public static String relativeTo(URI base, URI path) {
        URI resolved = URIs.resolve(base, path);
        if (URIs.within(base, resolved)) {
            URI relativePath = base.relativize(resolved);
            return relativePath.toASCIIString();
        }
        return null;
    }

    public static URI resolve(URI base, String path) {
        URI pathUri = URIs.create(URIs.normalize(path));
        return URIs.resolve(base, pathUri);
    }

    public static URI resolve(URI base, URI path) {
        URI normalizedBase = URIs.normalizeBase(base);
        if (NullOrEmpty.nullOrEmpty(path)) {
            return normalizedBase;
        }
        if (URIs.isJarUri(normalizedBase)) {
            return URIs.resolveJarUri(normalizedBase, path);
        }
        return normalizedBase.resolve(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status status(URI uri) {
        Status status = Status.DOES_NOT_EXIST;
        InputStream in = null;
        try {
            String scheme = uri.getScheme();
            if (scheme != null) {
                scheme = scheme.toLowerCase();
            }
            if (FILE_SCHEME.equals(scheme)) {
                Status status2 = URIs.fileExists(uri);
                return status2;
            }
            if (URIs.isJarUri(uri)) {
                Status status3 = URIs.jarExists(uri);
                return status3;
            }
            URLConnection conn = uri.toURL().openConnection();
            if (conn != null && (in = conn.getInputStream()) != null) {
                if (uri.toString().endsWith(PATH_SEPARATOR)) {
                    Status status4 = Status.FOLDER;
                    return status4;
                }
                Status status5 = Status.FILE;
                return status5;
            }
        }
        catch (IOException e) {
            status = Status.DOES_NOT_EXIST;
        }
        finally {
            Closeables.close(in);
        }
        return status;
    }

    public static URI uri(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme());
        builder.append("://");
        builder.append(request.getServerName());
        int port = request.getServerPort();
        if (port != -1) {
            builder.append(":");
            builder.append(port);
        }
        builder.append(request.getRequestURI());
        String query = request.getQueryString();
        if (query != null) {
            builder.append('?');
            builder.append(query);
        }
        return URIs.create(builder.toString());
    }

    public static boolean within(URI uri, URI candidate) {
        if (URIs.isJarUri(uri) && URIs.isJarUri(candidate)) {
            return URIs.withinJarUri(uri, candidate);
        }
        if (URIs.isPathUri(uri) && URIs.isPathUri(candidate)) {
            return URIs.withinPathUri(uri, candidate);
        }
        if (!uri.isAbsolute() || !candidate.isAbsolute()) {
            return false;
        }
        return !uri.relativize(candidate).isAbsolute();
    }

    private static Status fileExists(URI uri) {
        File f = Files.file(uri);
        if (f.exists()) {
            if (f.isDirectory()) {
                return Status.FOLDER;
            }
            return Status.FILE;
        }
        return Status.DOES_NOT_EXIST;
    }

    private static boolean isJarUri(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
        }
        return JAR_SCHEME.equals(scheme) || ZIP_SCHEME.equals(scheme) || JARCL_SCHEME.equals(scheme);
    }

    private static boolean isPathUri(URI uri) {
        return uri.getScheme() == null && uri.getPath() != null;
    }

    private static Status jarExists(URI jarUri) throws IOException {
        Pair<URI, URI> parsed = URIs.parseJarUri(jarUri);
        URI jarPath = parsed.first();
        URI withinJarPath = parsed.second();
        if (withinJarPath.toString().endsWith(PATH_SEPARATOR)) {
            return URIs.jarExists(jarPath, withinJarPath);
        }
        Status status = URIs.jarExists(jarPath, URIs.create(withinJarPath.toASCIIString() + PATH_SEPARATOR));
        if (Status.DOES_NOT_EXIST == status) {
            status = URIs.jarExists(jarPath, withinJarPath);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Status jarExists(URI jarPath, URI withinJarPath) throws IOException {
        URI uri = URIs.resolveJarUri(jarPath, withinJarPath);
        URLConnection conn = null;
        try {
            conn = uri.toURL().openConnection();
        }
        catch (FileNotFoundException e) {
            return Status.DOES_NOT_EXIST;
        }
        if (conn != null) {
            if (conn instanceof JarURLConnection) {
                JarURLConnection jar = (JarURLConnection)conn;
                JarEntry entry = null;
                try {
                    entry = jar.getJarEntry();
                }
                catch (IOException e) {
                    return Status.DOES_NOT_EXIST;
                }
                if (entry == null) {
                    return Status.DOES_NOT_EXIST;
                }
                if (entry.isDirectory()) {
                    return Status.FOLDER;
                }
                return Status.FILE;
            }
            InputStream in = null;
            try {
                in = conn.getInputStream();
                if (in != null) {
                    if (URIs.isFolder(uri)) {
                        Status entry = Status.FOLDER;
                        return entry;
                    }
                    Status entry = Status.FILE;
                    return entry;
                }
            }
            catch (IOException e) {
                Status status = Status.DOES_NOT_EXIST;
                return status;
            }
            finally {
                Closeables.close(in);
            }
        }
        return Status.DOES_NOT_EXIST;
    }

    private static String normalize(String text) {
        char driveLetter;
        for (int i = 0; i < UNWISE.length; ++i) {
            text = text.replace(UNWISE[i], ESCAPED[i]);
        }
        if ((text = text.replace('\\', '/').replaceAll("([^:]/)/+", "$1")).length() > 3 && text.charAt(1) == ':' && text.charAt(2) == '/') {
            driveLetter = Character.toUpperCase(text.charAt(0));
            if (driveLetter >= 'A' && driveLetter <= 'Z') {
                StringBuilder b = new StringBuilder(text.length() + 1);
                b.append("file:/");
                b.append(driveLetter);
                b.append(text.substring(1));
                text = b.toString();
            }
        } else if (text.length() > 4 && text.charAt(0) == '/' && text.charAt(2) == ':' && text.charAt(3) == '/' && (driveLetter = Character.toUpperCase(text.charAt(1))) >= 'A' && driveLetter <= 'Z') {
            StringBuilder b = new StringBuilder(text.length() + 1);
            b.append("file:/");
            b.append(driveLetter);
            b.append(text.substring(2));
            text = b.toString();
        }
        return text;
    }

    private static URI normalizeBase(URI base) {
        if (!base.isOpaque() && (base.getPath() == null || base.getPath().isEmpty())) {
            return base.resolve(PATH_SEPARATOR);
        }
        return base;
    }

    private static Pair<URI, URI> parseJarUri(URI jarUri) {
        String text = jarUri.toASCIIString();
        int bang = text.indexOf("!");
        String prefix = null;
        String path = null;
        if (bang == -1 || bang == text.length() - 1) {
            path = PATH_SEPARATOR;
            prefix = bang == -1 ? text : Text.stripSuffix(text, "!");
        } else {
            path = text.substring(bang + 1);
            prefix = text.substring(0, bang);
        }
        return Pair.pair(URIs.create(prefix), URIs.create(path));
    }

    private static URI resolveJarUri(URI jarUri, URI path) {
        Pair<URI, URI> jar = URIs.parseJarUri(jarUri);
        URI prefix = jar.first();
        URI basePath = jar.second();
        URI pathResolved = URIs.resolve(basePath, path);
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        b.append("!");
        b.append(pathResolved.toString());
        return URIs.create(b.toString());
    }

    private static boolean withinJarUri(URI uri, URI candidate) {
        Pair<URI, URI> j1 = URIs.parseJarUri(uri);
        Pair<URI, URI> j2 = URIs.parseJarUri(candidate);
        if (j1.first().equals(j2.first())) {
            return URIs.within(j1.second(), j2.second());
        }
        return false;
    }

    private static boolean withinPathUri(URI uri, URI candidate) {
        String prefix = uri.getPath();
        if (!prefix.endsWith(PATH_SEPARATOR)) {
            prefix = prefix + PATH_SEPARATOR;
        }
        return candidate.getPath().startsWith(prefix);
    }

    public static enum Status {
        DOES_NOT_EXIST,
        FILE,
        FOLDER;

    }

    public static class IllegalURIException
    extends TranslatableExceptionBase {
        private final String uri;
        private static final long serialVersionUID = -2655880863766154319L;

        private IllegalURIException(String reason, String uri) {
            this(reason, uri, -1, null);
        }

        private IllegalURIException(String reason, String uri, int position, Throwable cause) {
            super(IllegalURIException.message(reason, position), cause);
            this.uri = uri;
        }

        private static TranslatableMessage message(String reason, int position) {
            if (position < 0) {
                return new TranslatableMessage(CommonMessages.class, "URIs.0", "The URI is not well-formed, reason: {0}", reason);
            }
            return new TranslatableMessage(CommonMessages.class, "URIs.1", "The URI is not well-formed, reason: {0} at position: {1}", reason, position);
        }

        private IllegalURIException(URISyntaxException e) {
            this(e.getReason(), e.getInput(), e.getIndex(), e);
        }

        public String uri() {
            return this.uri;
        }
    }
}

