/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.common.util.CallStacks;
import oracle.dbtools.plugin.api.logging.Log;

public abstract class LogAdapterBase
implements Log {
    private final int callerStackDepth;
    private static final int CALLER_STACK_DEPTH = 4;

    protected LogAdapterBase(int callerStackDepth) {
        this.callerStackDepth = callerStackDepth;
    }

    public void fine(String msg) {
        this.log(FINE, msg);
    }

    public void fine(Throwable t) {
        this.log(FINE, t);
    }

    public void finer(String msg) {
        this.log(FINER, msg);
    }

    public void finer(Throwable t) {
        this.log(FINER, t);
    }

    public void finest(String msg) {
        this.log(FINEST, msg);
    }

    public void finest(Throwable t) {
        this.log(FINEST, t);
    }

    public void info(String msg) {
        this.log(INFO, msg);
    }

    public void info(Throwable t) {
        this.log(INFO, t);
    }

    public final boolean isLoggable(Level level) {
        LogRecord lr = this.logRecord(level, "");
        return this.isLoggable(lr);
    }

    public void severe(String msg) {
        this.log(SEVERE, msg);
    }

    public void severe(Throwable t) {
        this.log(SEVERE, t);
    }

    public void warning(String msg) {
        this.log(WARNING, msg);
    }

    public void warning(Throwable t) {
        this.log(WARNING, t);
    }

    protected boolean isLoggable(LogRecord lr) {
        return true;
    }

    protected abstract void log(LogRecord var1);

    private void inferCaller(LogRecord lr) {
        int stackDepth = this.callerStackDepth + 4;
        StackTraceElement methodCaller = CallStacks.caller(stackDepth);
        lr.setSourceClassName(methodCaller.getClassName());
        lr.setSourceMethodName(methodCaller.getMethodName());
    }

    private void log(Level level, String msg) {
        LogRecord lr = this.logRecord(level, "");
        if (this.isLoggable(lr)) {
            lr.setMessage(msg);
            this.log(lr);
        }
    }

    private void log(Level level, Throwable t) {
        LogRecord lr = this.logRecord(level, "");
        if (this.isLoggable(lr)) {
            lr.setMessage(t == null ? "" : t.getMessage());
            lr.setThrown(t);
            this.log(lr);
        }
    }

    private LogRecord logRecord(Level level, String msg) {
        LogRecord lr = new LogRecord(level, msg);
        this.inferCaller(lr);
        return lr;
    }
}

