/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Map;
import javax.inject.Inject;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableMultiMap;
import oracle.dbtools.common.immutables.MultiMaps;
import oracle.dbtools.common.immutables.impl.MapBuilder;
import oracle.dbtools.common.immutables.impl.MultiMapBuilder;
import oracle.dbtools.common.util.HasOrdering;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.plugin.api.collections.MultiMap;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
class MultiMapsProvider
implements MultiMaps {
    @Inject
    MultiMapsProvider() {
    }

    @Override
    public <K, V> ImmutableMultiMap.Builder<K, V> builder() {
        return MultiMapBuilder.newInstance(0);
    }

    @Override
    public <K, V> ImmutableMultiMap.Builder<K, V> builder(KeyedLookup<K, V> existing) {
        int size = existing.size();
        return MultiMapBuilder.newInstance(size).add(existing);
    }

    @Override
    public <K, V> ImmutableMultiMap.Builder<K, V> builder(Map<K, V> existing) {
        int size = existing.size();
        return MultiMapBuilder.newInstance(size).add(existing);
    }

    @Override
    public <K, V> ImmutableMultiMap<K, V> empty() {
        return this.builder().build();
    }

    @Override
    public <K, V> ImmutableMap<K, V> firstValueMap(MultiMap<K, V> map) {
        ImmutableMap.Builder<Object, Object> result = MapBuilder.newInstance(map.size(), null, null);
        if (map instanceof HasOrdering) {
            result.ordering(((HasOrdering)map).ordering());
            result.comparator(((HasOrdering)map).comparator());
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            result.add(key, value);
        }
        return result.build();
    }

    @Override
    public ImmutableMultiMap<String, String> multiMap(CharSequence ... keyValuePairs) {
        ImmutableMultiMap.Builder<String, String> map = this.builder();
        if (keyValuePairs.length % 2 == 1) {
            throw new IllegalArgumentException("Even number of key value pairs must be provided");
        }
        for (int i = 0; i < keyValuePairs.length; ++i) {
            CharSequence key = keyValuePairs[i];
            CharSequence value = keyValuePairs[++i];
            String k = null;
            String v = null;
            if (key != null) {
                k = key.toString();
            }
            if (value != null) {
                v = value.toString();
            }
            map.add(k, v);
        }
        return map.build();
    }

    @Override
    public <K, V> ImmutableMultiMap<K, V> multiMap(KeyedLookup<K, V> elements) {
        return this.builder(elements).build();
    }

    @Override
    public <K, V> ImmutableMultiMap<K, V> multiMap(Map<K, V> elements) {
        return this.builder(elements).build();
    }
}

