/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableCollection;
import oracle.dbtools.common.immutables.ImmutableIterator;
import oracle.dbtools.common.immutables.ImmutableList;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableMultiMap;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.EntryImpl;
import oracle.dbtools.common.immutables.impl.ListBuilder;
import oracle.dbtools.common.immutables.impl.ListImpl;
import oracle.dbtools.common.immutables.impl.MapImpl;
import oracle.dbtools.common.immutables.impl.MultiMapBuilder;
import oracle.dbtools.common.immutables.impl.SetImpl;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Ordering;

class MultiMapImpl<K, V>
implements ImmutableMultiMap<K, V> {
    private final ImmutableMap<K, Collection<V>> byKey;
    private final Comparator<? super K> comparator;
    private final ImmutableCollection<Map.Entry<K, V>> elements;
    private final Ordering ordering;
    private static final Collection<Map.Entry<Object, Object>> EMPTY_VALUES = Collections.emptyList();
    private static final MultiMapImpl<?, ?> EMPTY = new MultiMapImpl(EMPTY_VALUES, Ordering.SORTED, null);

    private MultiMapImpl(Collection<Map.Entry<K, V>> values, Ordering ordering, Comparator<? super K> comparator) {
        this.ordering = ordering;
        this.comparator = comparator;
        ListBuilder immutable = ListBuilder.newInstance(values.size());
        for (Map.Entry<K, V> entry : values) {
            immutable.add(EntryImpl.newInstance(entry));
        }
        this.elements = immutable.build();
        Map map = CollectionFactory.map(values.size(), ordering, comparator);
        for (Map.Entry<K, V> entry : values) {
            K key = entry.getKey();
            ArrayList<V> vals = (ArrayList<V>)map.get(key);
            if (vals == null) {
                vals = new ArrayList<V>();
                map.put(key, vals);
            }
            vals.add(entry.getValue());
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableList vals = ListImpl.newInstance((Iterable)entry.getValue());
            entry.setValue(vals);
        }
        Map immutableMap = map;
        this.byKey = MapImpl.newInstance(immutableMap, ordering, comparator);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.byKey.containsKey(key);
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableMultiMap) {
            ImmutableMultiMap other = (ImmutableMultiMap)obj;
            return this.elements.equals(other.entries());
        }
        return super.equals(obj);
    }

    @Override
    public V get(Object key) {
        Collection values = this.values(key);
        return (V)Iterables.first(values);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ImmutableSet<K> keySet() {
        return SetImpl.newInstance(this.byKey.keySet(), this.ordering, this.comparator);
    }

    @Override
    public ImmutableMap<K, Collection<V>> map() {
        return this.byKey;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> modify() {
        return MultiMapBuilder.newInstance(this.size()).ordering(this.ordering).comparator(this.comparator).add(this);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        ImmutableIterator i = this.entries().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == this ? "(this MultiMap)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this MultiMap)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public ImmutableCollection<V> values(Object key) {
        ImmutableCollection values = (ImmutableCollection)this.byKey.get(key);
        return values;
    }

    static <K, V> ImmutableMultiMap<K, V> newInstance(Collection<Map.Entry<K, V>> values, Ordering ordering, Comparator<? super K> comparator) {
        if (values == null) {
            throw new NullPointerException();
        }
        if (NullOrEmpty.nullOrEmpty(values)) {
            MultiMapImpl<?, ?> empty = EMPTY;
            return empty;
        }
        return new MultiMapImpl<K, V>(values, ordering, comparator);
    }
}

