/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Vertex;

class EdgeImpl<V, E>
implements Edge<V, E> {
    private final Vertex<V, E> destination;
    private final E value;

    EdgeImpl(E value, Vertex<V, E> destination) {
        this.value = value;
        this.destination = destination;
    }

    @Override
    public Vertex<V, E> destination() {
        return this.destination;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.destination == null ? other.destination() != null : !this.destination.equals(other.destination())) {
            return false;
        }
        return !(this.value == null ? other.value() != null : !this.value.equals(other.value()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Edge [destination=");
        builder.append(this.destination);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public E value() {
        return this.value;
    }
}

