/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.graph.TextRenderer;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.common.util.HasSize;

class DepthFirstTraversal<V, E> {
    private final Deque<Path<V, E>> cycles = new ArrayDeque<Path<V, E>>();
    private final VisitOrder ordering;
    private final TextRenderer<V, E> textRenderer;
    private final Visitor<V, E> visitor;
    private static final int DEFAULT_GRAPH_SIZE = 128;

    DepthFirstTraversal(Visitor<V, E> visitor, TextRenderer<V, E> textRenderer) {
        this(visitor, textRenderer, VisitOrder.POST);
    }

    DepthFirstTraversal(Visitor<V, E> visitor, TextRenderer<V, E> textRenderer, VisitOrder ordering) {
        this.visitor = visitor;
        this.textRenderer = textRenderer;
        this.ordering = ordering;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DepthFirstTraversal [visitor=");
        builder.append(this.visitor);
        builder.append(", ordering=");
        builder.append((Object)this.ordering);
        builder.append("]");
        return builder.toString();
    }

    void accept(Iterable<Vertex<V, E>> vertices) {
        VisitedVertices<V, E> visited = this.visitedVertices();
        for (Vertex<V, E> vertex : vertices) {
            this.accept(visited, vertex, this.visitor);
        }
    }

    void accept(Vertex<V, E> vertex) {
        VisitedVertices<V, E> visited = this.visitedVertices();
        this.accept(visited, vertex, this.visitor);
    }

    Collection<Path<V, E>> cycles() {
        return this.cycles;
    }

    private void accept(VisitedVertices<V, E> visited, Vertex<V, E> start, Visitor<V, E> visitor) {
        Path.Builder path = new Path.Builder(start, this.textRenderer);
        ArrayDeque levels = new ArrayDeque();
        levels.push(new Level<V, E>(start));
        while (!levels.isEmpty()) {
            Level currentLevel = (Level)levels.peek();
            Vertex currentVertex = currentLevel.vertex;
            if (VisitOrder.PRE == this.ordering) {
                this.visit(visited, currentVertex, visitor);
            }
            if (currentLevel.isEmpty()) {
                Level completed = (Level)levels.pop();
                if (!levels.isEmpty()) {
                    path.pop();
                }
                if (VisitOrder.POST != this.ordering) continue;
                this.visit(visited, completed.vertex, visitor);
                continue;
            }
            Edge edge = currentLevel.pop();
            Level level = new Level(edge.destination());
            if (levels.contains(level)) {
                Path.Builder<V, E> cycle = new Path.Builder(path.build()).push(edge);
                this.cycles.push(cycle.build());
                continue;
            }
            path.push(edge);
            levels.push(level);
        }
    }

    private void visit(VisitedVertices<V, E> visited, Vertex<V, E> vertex, Visitor<V, E> visitor) {
        if (!visited.contains(vertex)) {
            visitor.visit(vertex);
            visited.push(vertex);
        }
    }

    private VisitedVertices<V, E> visitedVertices() {
        return new VisitedVertices(128);
    }

    private static class VisitedVertices<V, E> {
        private final Map<Vertex<V, E>, Vertex<V, E>> visited;

        VisitedVertices(int initialCapacity) {
            this.visited = new HashMap<Vertex<V, E>, Vertex<V, E>>(initialCapacity);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VisitedVertices other = (VisitedVertices)obj;
            return !(this.visited == null ? other.visited != null : !this.visited.equals(other.visited));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.visited == null ? 0 : this.visited.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VisitedVertices [visited=");
            builder.append(this.visited);
            builder.append("]");
            return builder.toString();
        }

        boolean contains(Vertex<V, E> vertex) {
            return this.visited.containsKey(vertex);
        }

        void push(Vertex<V, E> vertex) {
            this.visited.put(vertex, vertex);
        }
    }

    private static class Level<V, E>
    implements HasSize {
        final Vertex<V, E> vertex;
        private final Deque<Edge<V, E>> edges = new ArrayDeque<Edge<V, E>>(128);

        Level(Vertex<V, E> vertex) {
            this.vertex = vertex;
            this.edges.addAll(vertex.edges());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Level other = (Level)obj;
            return !(this.vertex == null ? other.vertex != null : !this.vertex.equals(other.vertex));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.vertex == null ? 0 : this.vertex.hashCode());
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.edges.isEmpty();
        }

        @Override
        public int size() {
            return this.edges.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Level [vertex=");
            builder.append(this.vertex);
            builder.append(", #edges=");
            builder.append(this.edges.size());
            builder.append("]");
            return builder.toString();
        }

        Edge<V, E> pop() {
            return this.edges.pop();
        }
    }

    public static enum VisitOrder {
        POST,
        PRE;

    }
}

