/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ecid;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.ecid.ECIDPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;

public abstract class ECIDPrincipals {
    static final String ECID_PRINCIPAL = "ECID-Principal";

    public static ECIDPrincipal ecidPrincipal(HttpServletRequest request, boolean create) {
        ECIDPrincipal ecidPrincipal = (ECIDPrincipal)request.getAttribute(ECID_PRINCIPAL);
        if (ecidPrincipal == null) {
            if (create) {
                ecidPrincipal = ECIDPrincipals.ecidPrincipal();
                request.setAttribute(ECID_PRINCIPAL, (Object)ecidPrincipal);
            } else {
                throw new IllegalStateException();
            }
        }
        return ecidPrincipal;
    }

    static ECIDPrincipal ecidPrincipal() {
        String ecid = ECIDPrincipals.appServerEcid();
        if (ecid == null) {
            ecid = Identifiers.randomIdentifier();
        }
        return new ECIDPrincipal(ecid);
    }

    private static String appServerEcid() {
        return ECIDPrincipals.weblogicEcid();
    }

    private static String weblogicEcid() {
        try {
            Object result = ECIDPrincipals.invoke("weblogic.diagnostics.context.DiagnosticContextHelper", "getContextId");
            return (String)result;
        }
        catch (UnrecoverableException e) {
            return null;
        }
    }

    private static Object invoke(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method m = clazz.getMethod(methodName, new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            throw UnrecoverableException.unrecoverable(t);
        }
    }

    public static String ecid(CompoundPrincipal principal) {
        ECIDPrincipal ecid = principal.principal(ECIDPrincipal.class);
        if (ecid == null) {
            throw new IllegalStateException();
        }
        return ecid.getName();
    }

    @Deprecated
    public static CompoundPrincipal ecidPrincipal(CompoundPrincipal principal) {
        ECIDPrincipal ecid = principal.principal(ECIDPrincipal.class);
        if (ecid == null) {
            ecid = ECIDPrincipals.ecidPrincipal();
            return principal.replace(ECIDPrincipal.class, ecid);
        }
        return principal;
    }
}

