/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.cache;

class CacheEntry<V> {
    private transient long created;
    private transient long lastAccessed;
    private transient long lastModified;
    private volatile V value;

    CacheEntry(V value) {
        this.value = value;
        this.created = System.currentTimeMillis();
        this.lastAccessed = 0L;
        this.lastModified = 0L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheEntry other = (CacheEntry)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CacheEntry [value=");
        builder.append(this.value);
        builder.append(", created=");
        builder.append(this.created);
        builder.append(", lastAccessed=");
        builder.append(this.lastAccessed);
        builder.append(", lastModified=");
        builder.append(this.lastModified);
        builder.append("]");
        return builder.toString();
    }

    long created() {
        return this.created;
    }

    V get() {
        this.lastAccessed = System.currentTimeMillis();
        return this.value;
    }

    long lastAccessed() {
        return this.lastAccessed;
    }

    long lastModified() {
        return this.lastModified;
    }

    V set(V newValue) {
        V oldValue = this.value;
        this.value = newValue;
        this.lastModified = System.currentTimeMillis();
        return oldValue;
    }
}

