/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.searchbar.Result;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.ResultModel;
import oracle.ideimpl.searchbar.ResultPanel;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchField;

class ResultContainer
extends JPanel {
    private GhostPalette gp;
    private JLabel runningLabel;
    private ResultPanel resultPanel;
    private SearchField searchField;
    private ResultModel model;
    private ResultModel.ResultListener runningListener;
    private Timer repositionTimer;
    private static int MIN_WIDTH = 500;
    private static int MAX_WIDTH = 500;

    public ResultContainer(SearchField searchField, ShowAllProvider showAllProvider) {
        this.searchField = searchField;
        this.init(showAllProvider);
    }

    private void init(ShowAllProvider showAllProvider) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createLabelComponent(), "North");
        this.putClientProperty(UIConstants.VETO_HIERARCHY_CONVERSION, true);
        this.resultPanel = new ResultPanel(showAllProvider, this.searchField);
        this.add((Component)this.resultPanel, "Center");
        this.repositionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ResultContainer.this.gp == null) {
                    ResultContainer.this.repositionTimer.stop();
                    return;
                }
                ResultContainer.this.updateSize();
                ResultContainer.this.updateLocation();
            }
        });
        this.repositionTimer.setRepeats(true);
        this.repositionTimer.setCoalesce(true);
    }

    private JComponent createLabelComponent() {
        JPanel p = new JPanel(new BorderLayout(20, 10));
        JLabel searchLabel = new JLabel(Bundle.get("SEARCH_RESULTS"));
        searchLabel.setForeground(UIManager.getColor(ColorProvider.HEADER_FOREGROUND));
        searchLabel.setFont(searchLabel.getFont().deriveFont(1));
        searchLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 3, 0));
        p.add((Component)searchLabel, "West");
        this.runningLabel = new JLabel(OracleIcons.getIcon((String)"throbber.gif"));
        this.runningLabel.setVisible(true);
        this.runningLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 2));
        p.add((Component)this.runningLabel, "East");
        p.setBackground(UIManager.getColor(ColorProvider.HEADER_BACKGROUND));
        p.setOpaque(true);
        return p;
    }

    private GhostPalette createGhostPalette() {
        this.gp = new GhostPalette();
        this.gp.setResizable(false);
        this.gp.setMovable(false);
        this.gp.setReceivesFocus(false);
        this.gp.setCloseVisible(false);
        this.gp.setLayout((LayoutManager)new BorderLayout());
        this.gp.getContentPanel().setBackground(UIManager.getColor(ColorProvider.BACKGROUND));
        this.gp.add((Component)this);
        this.gp.setBorder((Border)new ListBorder());
        this.gp.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                ResultContainer.this.hideResults();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        return this.gp;
    }

    void hideResults() {
        if (this.gp != null) {
            GhostPalette expiringGP = this.gp;
            this.gp = null;
            this.repositionTimer.stop();
            expiringGP.hidePanel();
            this.model.removeResultListener(this.resultPanel);
            this.model.removeResultListener(this.runningListener);
            this.runningListener = null;
            this.model = null;
            this.resultPanel.clearResults();
        }
    }

    void updateLocation() {
        Point location = this.searchField.getLocationOnScreen();
        JFrame frame = (JFrame)SwingUtilities.windowForComponent((Component)this.searchField);
        location.x += this.searchField.getWidth();
        location.y += this.searchField.getHeight() + 1;
        SwingUtilities.convertPointFromScreen(location, frame.getLayeredPane());
        location.x -= this.gp.getWidth();
        if (!location.equals(this.gp.getLocation())) {
            this.gp.setLocation(location);
        }
    }

    void disconnect() {
        this.model.removeResultListener(this.resultPanel);
        this.model.removeResultListener(this.runningListener);
    }

    void showResults(ResultModel model) {
        if (this.gp != null && this.gp.isShowing()) {
            this.updateSize();
            this.updateLocation();
            return;
        }
        this.gp = this.createGhostPalette();
        this.updateSize();
        this.updateLocation();
        this.model = model;
        model.addResultListener(this.resultPanel);
        this.resultPanel.setRunning(model.isRunning());
        this.updateBusy(model.isRunning());
        this.runningListener = new ResultModel.ResultListener(){

            @Override
            public void newResults(Collection<Result<?>> results) {
            }

            @Override
            public void deletedResult(Result result) {
            }

            @Override
            public void deletedResults(Collection<Result<?>> results) {
            }

            @Override
            public void clearResults() {
            }

            @Override
            public void runningChange(boolean isRunning) {
                ResultContainer.this.updateBusy(isRunning);
            }
        };
        model.addResultListener(this.runningListener);
        JFrame frame = (JFrame)SwingUtilities.windowForComponent((Component)this.searchField);
        this.gp.show(false, false);
        this.repositionTimer.start();
    }

    @Override
    public boolean isShowing() {
        return this.gp != null && this.gp.isShowing();
    }

    void updateSize() {
        this.gp.pack();
        this.gp.setSize(this.gp.getWidth(), this.gp.getHeight() - 10);
        if (this.gp.getWidth() < MIN_WIDTH) {
            this.gp.setSize(MIN_WIDTH, this.gp.getHeight());
            this.revalidate();
        }
        if (this.gp.getWidth() % 100 != 0) {
            int width = (this.gp.getWidth() / 100 + 1) * 100;
            width = Math.min(MAX_WIDTH, width);
            this.gp.setSize(width, this.gp.getHeight());
            this.revalidate();
        }
    }

    void updateBusy(final boolean isBusy) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultContainer.this.runningLabel.setVisible(isBusy);
                if (!isBusy && ResultContainer.this.model != null) {
                    ResultContainer.this.model.setRunning(isBusy);
                }
            }
        });
    }

    Dimension getPreferredWindowSize() {
        Dimension d = this.getPreferredSize();
        return d;
    }

    public void addActionListener(ActionListener l) {
        this.resultPanel.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.resultPanel.removeActionListener(l);
    }

    Action selectNextRowAction() {
        return this.resultPanel.selectNextRowAction();
    }

    Action selectPreviousRowAction() {
        return this.resultPanel.selectPreviousRowAction();
    }

    public Result selection() {
        return this.resultPanel.selection();
    }

    private class ListBorder
    implements Border {
        private Insets i = new Insets(1, 1, 4, 1);

        private ListBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIManager.getColor(ColorProvider.BACKGROUND));
            g.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            if (ResultContainer.this.resultPanel.getListsVisibleCount() % 2 != 0) {
                g.setColor(UIManager.getColor(ColorProvider.STRIPE_BACKGROUND));
                g.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            }
            g.setColor(UIManager.getColor(ColorProvider.BORDER));
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.i;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

