/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.TemporalController;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.ui.actions.ActionControl;

public class TemporalActionControl
extends ActionControl {
    private final OraTemporalDatum _defaultValue;
    private final OraTemporalDatum _value;
    private final TemporalController _controller;
    private final DateFormat _displayFormat;
    private final Format _resultFormat;
    private final JPanel _ui;

    public TemporalActionControl(String string, String string2, Format format) {
        this(string, string2, null, format, null);
    }

    public TemporalActionControl(String string, String string2, Format format, DateFormat dateFormat) {
        this(string, string2, null, format, dateFormat);
    }

    public TemporalActionControl(String string, String string2, OraTemporalDatum oraTemporalDatum, Format format) {
        this(string, string2, oraTemporalDatum, format, null);
    }

    public TemporalActionControl(String string, String string2, OraTemporalDatum oraTemporalDatum, Format format, DateFormat dateFormat) {
        super(string, string2);
        this._defaultValue = oraTemporalDatum;
        this._value = this._defaultValue != null ? (OraTemporalDatum)this._defaultValue.clone() : this.getNonNullDefaultValue();
        this._resultFormat = format != null ? (Format)format.clone() : null;
        this._displayFormat = dateFormat != null ? (DateFormat)dateFormat.clone() : null;
        this._controller = new TemporalController(this._value, true, this._displayFormat);
        this._ui = this._controller.getEditorPanel();
        this._value.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TemporalActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        if (this._resultFormat instanceof DateFormat) {
            value.set(this._resultFormat.format(this._value.getTime()));
        } else if (this._resultFormat != null) {
            value.set(this._resultFormat.format(this._value));
        } else {
            value.set(this._value.toString());
        }
        return value;
    }

    @Override
    public Component getUI() {
        return this._ui;
    }

    @Override
    public void reset() {
        this.set(this._defaultValue);
    }

    @Override
    public void setEditable(boolean bl) {
        this.enableUI(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._controller.setEnabled(bl);
    }

    public void set(Calendar calendar) {
        if (calendar == null) {
            this.set(this.getNonNullDefaultValue());
        } else {
            this._value.setCalendar(calendar);
        }
    }

    public void set(Date date) {
        if (date == null) {
            this.set(this.getNonNullDefaultValue());
        } else {
            this._value.setTime(date);
        }
    }

    public void set(OraTemporalDatum oraTemporalDatum) {
        if (oraTemporalDatum == null) {
            this.set(this.getNonNullDefaultValue());
        } else {
            this._value.setValue(oraTemporalDatum);
        }
    }

    public Calendar getCalendar() {
        return this._value.getCalendar();
    }

    public Date getTime() {
        return this._value.getTime();
    }

    public OraTemporalDatum getTemporalDatum() {
        return (OraTemporalDatum)this._value.clone();
    }

    public OraTemporalDatum getNonNullDefaultValue() {
        return OraTIMESTAMPTZ.getInstance();
    }
}

