/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.UiResources;

public class FileSizeActionControlPanel
extends JPanel {
    public static final String SIZE = "Size";
    public static final String UNIT = "Unit";
    public static final String BYTES = "Bytes";
    public static final String SIZE_CLAUSE = "SizeClause";
    public static final String SIZE_BYTE = UiResources.get("SIZE_BYTE");
    public static final String SIZE_KILO_BYTE = UiResources.get("SIZE_KILO_BYTE");
    public static final String SIZE_MEGA_BYTE = UiResources.get("SIZE_MEGA_BYTE");
    public static final String SIZE_GIGA_BYTE = UiResources.get("SIZE_GIGA_BYTE");
    public static final String SIZE_TERA_BYTE = UiResources.get("SIZE_TERA_BYTE");
    public static final String SIZE_PETA_BYTE = UiResources.get("SIZE_PETA_BYTE");
    public static final String SIZE_EXA_BYTE = UiResources.get("SIZE_EXA_BYTE");
    public static final String SIZE_ZETTA_BYTE = UiResources.get("SIZE_ZETTA_BYTE");
    public static final String SIZE_YOTTA_BYTE = UiResources.get("SIZE_YOTTA_BYTE");
    private long _defaultSize;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private NumberFormat format = NumberFormat.getIntegerInstance();
    private JFormattedTextField sizeFormattedTextField = new JFormattedTextField(this.format);
    private JComboBox unitsComboBox = new JComboBox();
    private DefaultComboBoxModel _unitsModel = new DefaultComboBoxModel<Object>(new Object[]{SIZE_BYTE, SIZE_KILO_BYTE, SIZE_MEGA_BYTE, SIZE_GIGA_BYTE, SIZE_TERA_BYTE});

    public FileSizeActionControlPanel(long l) {
        this._defaultSize = l;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.sizeFormattedTextField.setName("sizeFormattedTextField");
        this.unitsComboBox.setName("unitsComboBox");
        this.format.setGroupingUsed(false);
        this.unitsComboBox.setModel(this._unitsModel);
        this.reset();
        this.setLayout(this.gridBagLayout);
        this.add((Component)this.sizeFormattedTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 4), 0, 0));
        this.add((Component)this.unitsComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setSize(long l) {
        this.unitsComboBox.setSelectedItem(SIZE_BYTE);
        this.sizeFormattedTextField.setText(Long.toString(l));
    }

    public String getSizeText() {
        return this.sizeFormattedTextField.getText();
    }

    public String getUnits() {
        return this.unitsComboBox.getSelectedItem().toString();
    }

    public long getSizeBytes() {
        long l;
        String string = this.getSizeText();
        String string2 = this.getUnits();
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        long l2 = 0L;
        if (string2.equals(SIZE_BYTE)) {
            l2 = l;
        } else if (string2.equals(SIZE_KILO_BYTE)) {
            l2 = l * 1024L;
        } else if (string2.equals(SIZE_MEGA_BYTE)) {
            l2 = l * 0x100000L;
        } else if (string2.equals(SIZE_GIGA_BYTE)) {
            l2 = l * 0x40000000L;
        } else if (string2.equals(SIZE_TERA_BYTE)) {
            l2 = l * 0x10000000000L;
        } else if (string2.equals(SIZE_PETA_BYTE)) {
            l2 = l * 0x4000000000000L;
        } else if (string2.equals(SIZE_EXA_BYTE)) {
            l2 = l * 0x1000000000000000L;
        }
        return l2;
    }

    public String getSizeClause() {
        String string = this.getSizeText();
        String string2 = this.getUnits();
        String string3 = null;
        if (string2.equals(SIZE_BYTE)) {
            string3 = string;
        } else if (string2.equals(SIZE_KILO_BYTE)) {
            string3 = string + "K";
        } else if (string2.equals(SIZE_MEGA_BYTE)) {
            string3 = string + "M";
        } else if (string2.equals(SIZE_TERA_BYTE)) {
            string3 = string + "T";
        } else if (string2.equals(SIZE_GIGA_BYTE)) {
            string3 = string + "G";
        } else if (string2.equals(SIZE_PETA_BYTE)) {
            string3 = string + "P";
        } else if (string2.equals(SIZE_EXA_BYTE)) {
            string3 = string + "E";
        } else if (string2.equals(SIZE_ZETTA_BYTE)) {
            string3 = string + "Z";
        } else if (string2.equals(SIZE_YOTTA_BYTE)) {
            string3 = string + "Y";
        }
        return string3;
    }

    public void reset() {
        long l = 0L;
        String string = null;
        if (this._defaultSize == 0L) {
            string = SIZE_KILO_BYTE;
            l = 0L;
        } else if (this.useBlockSize(this._defaultSize, 0x1000000000000000L)) {
            string = SIZE_EXA_BYTE;
            l = this._defaultSize / 0x1000000000000000L;
        } else if (this.useBlockSize(this._defaultSize, 0x4000000000000L)) {
            string = SIZE_PETA_BYTE;
            l = this._defaultSize / 0x4000000000000L;
        } else if (this.useBlockSize(this._defaultSize, 0x10000000000L)) {
            string = SIZE_TERA_BYTE;
            l = this._defaultSize / 0x10000000000L;
        } else if (this.useBlockSize(this._defaultSize, 0x40000000L)) {
            string = SIZE_GIGA_BYTE;
            l = this._defaultSize / 0x40000000L;
        } else if (this.useBlockSize(this._defaultSize, 0x100000L)) {
            string = SIZE_MEGA_BYTE;
            l = this._defaultSize / 0x100000L;
        } else if (this.useBlockSize(this._defaultSize, 1024L)) {
            string = SIZE_KILO_BYTE;
            l = this._defaultSize / 1024L;
        } else {
            string = SIZE_BYTE;
            l = this._defaultSize;
        }
        this.sizeFormattedTextField.setText(Long.toString(l));
        this.unitsComboBox.setSelectedItem(string);
    }

    private boolean useBlockSize(long l, long l2) {
        return l / l2 * l2 == l;
    }

    public JFormattedTextField getSizeFormattedTextField() {
        return this.sizeFormattedTextField;
    }

    public JComboBox getUnitsComboBox() {
        return this.unitsComboBox;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.sizeFormattedTextField.setEnabled(bl);
        this.unitsComboBox.setEnabled(bl);
    }

    void setEditable(boolean bl) {
        this.sizeFormattedTextField.setEditable(bl);
    }
}

