/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.sftp.SftpLogger;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.rt.json.JSONToMap;
import oracle.ide.Ide;
import oracle.javatools.util.ModelUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class SftpUtil {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpUtil.class.getName());
    boolean completed = false;
    int _timeout = 60000;

    private static Map<String, String> getResults(HttpEntity httpEntity) {
        try {
            Map map = JSONToMap.read((InputStream)httpEntity.getContent());
            return map;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean SftpPut(SftpParms sftpParms, boolean bl) {
        File file = new File(sftpParms.getLocalFile());
        if (this.SftpPut(sftpParms)) {
            if (bl) {
                try {
                    this.createDeploymentRow(sftpParms.getCloudConnectionName(), sftpParms.getImportName(), sftpParms.getRemoteFile(), "DEPLOY", String.valueOf(file.length()));
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void createDeploymentRow(String string, String string2, String string3, String string4, String string5) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            CConnection cConnection = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = cConnection.createPost("/create_deploy_record/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            arrayList.add(new BasicNameValuePair("p_file_name", string3));
            arrayList.add(new BasicNameValuePair("p_file_type", string4));
            arrayList.add(new BasicNameValuePair("p_file_size", string5));
            arrayList.add(new BasicNameValuePair("service_name", cConnection.getDefaultServiceURI().toString()));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            cConnection.executeRequest((HttpUriRequest)httpPost, new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Created Successfully  ################");
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportWizArb.getString("FTP_DONE_MSG"), ExportWizArb.getString("FTP_DONE_TITLE"), 1);
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getStatusCode() + ":" + httpResponse.getStatusLine().getReasonPhrase());
                    throw new RuntimeException(ExportWizArb.getString("FTP_ERROR_WRITE_DEPLOY"));
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
            throw exception;
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeploymentStatus(String string, String string2, String string3) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            CConnection cConnection = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = cConnection.createPost("/update_deploy_status/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            arrayList.add(new BasicNameValuePair("p_status", string3));
            arrayList.add(new BasicNameValuePair("user_name", "user_name"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            cConnection.executeRequest((HttpUriRequest)httpPost, new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Successfully Updated  ################");
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeploymentLogs(String string, String string2) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            CConnection cConnection = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = cConnection.createPost("/clear_deploy_logs/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            cConnection.executeRequest((HttpUriRequest)httpPost, new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Logs Cleared Successfully  ################");
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SftpTestConnection(SftpParms sftpParms) {
        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Testing sftp Connection");
        boolean bl = true;
        try {
            JSch.setLogger((Logger)new SftpLogger());
            JSch jSch = new JSch();
            Session session = null;
            ChannelSftp channelSftp = null;
            try {
                LOGGER.info("Testing connection to: " + sftpParms.getHost() + ":" + sftpParms.getPort());
                if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                    LOGGER.info("Using Key File:" + sftpParms.getKeyFile());
                    URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                    if (uRL == null) {
                        throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                    }
                    URI uRI = uRL.toURI();
                    jSch.addIdentity(new File(uRI).getAbsolutePath());
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                    LOGGER.info("Using username/passwd:" + sftpParms.getUser() + "/*****");
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                    session.setPassword(sftpParms.getPassString());
                }
                LOGGER.info("Connecting...");
                this.connectSession(session);
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getLocalizedMessage());
                bl = false;
            }
            finally {
                channelSftp.disconnect();
                session.disconnect();
            }
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getLocalizedMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean SftpPut(SftpParms sftpParms) {
        SftpProgressMonitor sftpProgressMonitor;
        int n;
        InputStream inputStream;
        ChannelSftp channelSftp;
        try {
            JSch.setLogger((Logger)new SftpLogger());
            JSch jSch = new JSch();
            Session session = null;
            channelSftp = null;
            inputStream = null;
            try {
                Comparable<URI> comparable;
                LOGGER.info("Connecting to: " + sftpParms.getHost() + ":" + sftpParms.getPort());
                if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                    LOGGER.info("Using Key File:" + sftpParms.getKeyFile());
                    URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                    if (uRL == null) {
                        throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                    }
                    comparable = uRL.toURI();
                    jSch.addIdentity(new File((URI)comparable).getAbsolutePath());
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                    LOGGER.info("Using username/passwd:" + sftpParms.getUser() + "/*****");
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                    session.setPassword(sftpParms.getPassString());
                }
                this.connectSession(session);
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                LOGGER.info("Connected...");
                boolean bl = false;
                LOGGER.info("Checking service name:" + sftpParms.getCloudServiceName());
                if (ModelUtil.hasLength((String)sftpParms.getCloudServiceName())) {
                    try {
                        channelSftp.cd(sftpParms.getCloudServiceName());
                        LOGGER.info("Logged into domain level and cd to service");
                    }
                    catch (SftpException sftpException) {
                        LOGGER.info("No Service Name directory:" + sftpException.getLocalizedMessage());
                    }
                    try {
                        channelSftp.cd("upload");
                        bl = true;
                        LOGGER.info("cd upload");
                    }
                    catch (SftpException sftpException) {
                        LOGGER.severe("No upload directory!:" + sftpException.getLocalizedMessage());
                    }
                }
                if (!bl && ModelUtil.hasLength((String)sftpParms.getServerDir())) {
                    channelSftp.cd(sftpParms.getServerDir());
                }
                LOGGER.info("Gathering file information");
                comparable = new File(sftpParms.getLocalFile());
                Long l = ((File)comparable).length();
                if (((File)comparable).exists()) {
                    LOGGER.info("File is valid and exists locally: " + ((File)comparable).getName() + " " + l.toString());
                    inputStream = new BufferedInputStream(new FileInputStream((File)comparable));
                    if (sftpParms.getRemoteFile() == null) {
                        sftpParms.setRemoteFile(((File)comparable).getName());
                    }
                    LOGGER.info("Validating remote file: " + sftpParms.getRemoteFile());
                    Vector vector = null;
                    try {
                        vector = channelSftp.ls(sftpParms.getRemoteFile());
                    }
                    catch (SftpException sftpException) {
                        if (sftpException.id != 2) throw sftpException;
                    }
                    if (vector != null && vector.size() > 0) {
                        LOGGER.info("Remote file exists removing it!");
                        try {
                            channelSftp.rm(sftpParms.getRemoteFile());
                        }
                        catch (Exception exception) {
                            LOGGER.severe("Unable to remove remote file exiting deployment processes!!!!");
                            boolean bl2 = false;
                            channelSftp.disconnect();
                            session.disconnect();
                            inputStream.close();
                            return bl2;
                        }
                    }
                } else {
                    LOGGER.severe("Local file not found " + ((File)comparable).getAbsolutePath());
                    boolean bl3 = false;
                    return bl3;
                }
                LOGGER.info("Loading file to FTP server: " + sftpParms.getRemoteFile());
                n = 0;
                sftpProgressMonitor = new SftpProgressMonitor(){

                    public void init(int n, String string, String string2, long l) {
                    }

                    public boolean count(long l) {
                        LOGGER.fine("Transfered :" + l);
                        return true;
                    }

                    public void end() {
                        SftpUtil.this.completed = true;
                    }
                };
            }
            catch (SftpException sftpException) {
                LOGGER.severe(" SFTP EXCEPTION: " + sftpException.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                channelSftp.disconnect();
                session.disconnect();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Transfer exception " + exception.getMessage());
            return false;
        }
        while (n < 3) {
            if (this.completed) return this.completed;
            try {
                if (n == 0) {
                    channelSftp.put(inputStream, sftpParms.getRemoteFile(), sftpProgressMonitor);
                    continue;
                }
                channelSftp.put(inputStream, sftpParms.getRemoteFile(), sftpProgressMonitor, 1);
            }
            catch (SftpException sftpException) {
                int n2;
                LOGGER.severe("FAILED FTP transfer " + n + " time(s). Will retry transfer 3 times.");
                LOGGER.log(Level.SEVERE, sftpException.getMessage(), sftpException);
                if (++n != 3 || (n2 = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), ExportWizArb.getString("FTP_RETRY_MSG"), ExportWizArb.getString("FTP_ERROR_TITLE"), 0, 0, null, null, null)) != 0) continue;
                n = 0;
            }
        }
        return this.completed;
    }

    private void connectSession(Session session) throws JSchException {
        LOGGER.info("Connecting...");
        session.setConfig("StrictHostKeyChecking", "no");
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            try {
                session.setTimeout(this._timeout);
                session.setServerAliveInterval(this._timeout);
                session.connect();
            }
            catch (JSchException jSchException) {
                if (i == 3) {
                    throw jSchException;
                }
                bl = false;
            }
            if (!bl) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteSameSize(SftpParms sftpParms) {
        JSch.setLogger((Logger)new SftpLogger());
        JSch jSch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        try {
            SftpATTRS sftpATTRS;
            Long l;
            Long l2;
            Comparable<URI> comparable;
            if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                if (uRL == null) {
                    throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                }
                comparable = uRL.toURI();
                jSch.addIdentity(new File((URI)comparable).getAbsolutePath());
                session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
            } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                session.setPassword(sftpParms.getPassString());
            }
            this.connectSession(session);
            channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            boolean bl = false;
            if (ModelUtil.hasLength((String)sftpParms.getCloudServiceName())) {
                try {
                    channelSftp.cd(sftpParms.getCloudServiceName());
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
                try {
                    channelSftp.cd("upload");
                    bl = true;
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
            }
            if (!bl && ModelUtil.hasLength((String)sftpParms.getServerDir())) {
                channelSftp.cd(sftpParms.getServerDir());
            }
            if (!(l2 = Long.valueOf(((File)(comparable = new File(sftpParms.getLocalFile()))).length())).equals(l = Long.valueOf((sftpATTRS = channelSftp.lstat(sftpParms.getRemoteFile())).getSize()))) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            boolean bl = false;
            return bl;
        }
        finally {
            channelSftp.disconnect();
            session.disconnect();
        }
        return true;
    }
}

