/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.raptor.runner.Procedure;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.runner.Type;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlTypedef;
import oracle.javatools.parser.plsql.data.PlsqlVariable;
import oracle.javatools.util.ModelUtil;

public final class ParamTableModel
extends AbstractTableModel {
    private static final int NAME_IDX = 0;
    private static final int TYPE_IDX = 1;
    private static final int MODE_IDX = 2;
    private static final int VALUE_IDX = 3;
    private static final int POSITION_POS = 1;
    private static final int NAME_POS = 2;
    private static final int LEVEL_POS = 3;
    private static final int DATA_TYPE_POS = 4;
    private static final int MODE_POS = 5;
    private static final int TYPE_LEN_POS = 6;
    private static final int TYPE_OWNER_POS = 9;
    private static final int TYPE_NAME_POS = 10;
    private static final int TYPE_SUBNAME_POS = 11;
    private static final int PLS_TYPE_POS = 12;
    private String[] _headers;
    private List<Parameter> _paramList = new ArrayList<Parameter>();
    private static final String TYPE_CONSTRUCTOR_QUERY = "select count(*) \nfrom all_type_attrs where owner = :OWNER and type_name = :NAME";
    int attributeCount = -1;
    private static final String COLUMN_QUERY = "select column_name, data_type\nfrom all_tab_columns where owner = ? and table_name = ?";
    private static final Set<String> FAKE_NAMES = new HashSet<String>(Arrays.asList("REF CURSOR", "PL/SQL TABLE"));
    private static final Map<String, String> BOGUS_NAMES = new HashMap<String, String>();

    public ParamTableModel(Procedure procedure) throws SQLException {
        this();
        if (procedure.trEvents == null) {
            this.initProcTabMdl(procedure);
        } else {
            this.initTrigTabMdl(procedure);
        }
    }

    public ParamTableModel() {
        this._headers = new String[4];
        this._headers[0] = RunnerArb.getString("HEADER_PARAMETER");
        this._headers[1] = RunnerArb.getString("HEADER_DATA_TYPE");
        this._headers[2] = RunnerArb.getString("HEADER_MODE");
        this._headers[3] = RunnerArb.getString("HEADER_VALUE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProcTabMdl(Procedure procedure) throws SQLException {
        String string;
        Type type;
        int n;
        Parameter[] parameterArray;
        Object object;
        PlsqlType[] plsqlTypeArray;
        Query query;
        Connection connection = procedure.getConnection();
        String string2 = procedure.getOwner();
        String string3 = procedure.getName();
        int n2 = procedure.getOverload();
        int n3 = procedure.getObjectID();
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            query = ParamTableModel.getQuery(connection);
            plsqlTypeArray = new HashMap();
            plsqlTypeArray.put("OWNER", string2);
            plsqlTypeArray.put("ID", new Integer(n3));
            plsqlTypeArray.put("NAME", string3);
            plsqlTypeArray.put("OVERLOAD", Integer.toString(n2));
            if (connection == null) {
                throw new SQLException("Failed to obtain database connection");
            }
            if (!Connections.getInstance().lock(connection)) {
                throw new SQLException("Failed obtain db connection lock ");
            }
            object = null;
            resultSet = DBUtil.getInstance((Connection)connection).executeQuery(query.getSql(), plsqlTypeArray);
            while (resultSet.next()) {
                String string4;
                Object object2;
                Object object3;
                if (resultSet.getInt(3) != 0) continue;
                parameterArray = resultSet.getString(2);
                n = resultSet.getInt(1);
                if (n != 0 && parameterArray == null) continue;
                type = null;
                string = resultSet.getString(12);
                if (string == null && (object3 = resultSet.getString(10)) != null) {
                    string = "";
                    object2 = resultSet.getString(9);
                    if ("PUBLIC".equals(object2)) {
                        object2 = null;
                    }
                    string4 = resultSet.getString(11);
                    if (object2 != null) {
                        string = string + (String)object2 + ".";
                    }
                    string = string + (String)object3;
                    if (string4 != null) {
                        string = string + "." + string4;
                    }
                    type = new Type(string, false);
                }
                if (type == null) {
                    string = resultSet.getString(4);
                    if (string == null) {
                        type = new Type("UNKNOWN TYPE", false);
                    } else if (ParamTableModel.unknownType(string)) {
                        type = new Type(null, string, "REF CURSOR".equals(string));
                        bl = true;
                    } else {
                        type = new Type(ParamTableModel.validateTypeName(string));
                    }
                }
                if (type.isCharType() || "RAW".equals(type.getTypeName())) {
                    object3 = resultSet.getObject(6);
                    object2 = object3 instanceof Number ? (Number)((Number)object3) : (Number)new Integer(200);
                    string4 = new FastStringBuffer(type.getTypeName());
                    string4.append("(").append(object2).append(")");
                    string = string4.toString();
                    type.setTypeName(string);
                }
                if (n == 0) {
                    this._paramList.add(new Parameter(type));
                    continue;
                }
                object3 = resultSet.getString(5);
                if ("SELF".equals(parameterArray)) {
                    object = type;
                    continue;
                }
                this._paramList.add(new Parameter((String)parameterArray, type, Mode.getMode((String)object3), false));
            }
            if (object != null) {
                plsqlTypeArray = new HashMap();
                plsqlTypeArray.put("OWNER", string2);
                parameterArray = object.getTypeName();
                n = parameterArray.indexOf(46);
                if (0 < n) {
                    parameterArray = parameterArray.substring(n + 1);
                }
                plsqlTypeArray.put("NAME", parameterArray);
                DBUtil.closeResultSet((ResultSet)resultSet);
                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(TYPE_CONSTRUCTOR_QUERY, (Map)plsqlTypeArray);
                if (resultSet.next()) {
                    this._paramList.add(new Parameter((Type)object, resultSet.getInt(1)));
                }
            }
            Connections.getInstance().unlock(connection);
        }
        catch (Throwable throwable) {
            Connections.getInstance().unlock(connection);
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        if (bl) {
            query = procedure.getParseTree();
            plsqlTypeArray = this._resolveParsedProgram((PlsqlRoot)query, procedure);
            object = ParamTableModel.getTypedefs((PlsqlRoot)query);
            parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
            for (n = 0; n < parameterArray.length; ++n) {
                type = parameterArray[n].getType();
                if (type.getTypeName() != null) continue;
                if (plsqlTypeArray.length == 0) {
                    type.setTypeName(type.getDeclaredName());
                    continue;
                }
                string = plsqlTypeArray[n].getTypeName().toString();
                if (!"sys_refcursor".equalsIgnoreCase(string)) {
                    string = ParamTableModel.getQualifiedName(string, procedure);
                }
                type.setTypeName(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTrigTabMdl(Procedure procedure) {
        Connection connection = procedure.getConnection();
        String string = procedure.getOwner();
        String string2 = procedure.getName();
        Connection connection2 = connection;
        synchronized (connection2) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(COLUMN_QUERY);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("column_name");
                    String string4 = resultSet.getString("data_type");
                    this._paramList.add(new Parameter(string3, new Type(string4), Mode.IN, false));
                }
            }
            catch (SQLException sQLException) {
                SQLErrorDialog.showErrorDialog(null, (String)RunnerArb.getString("ERROR_MSG_TITLE"), (SQLException)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public int findColumn(String string) {
        for (int i = 0; i < this._headers.length; ++i) {
            if (!this._headers[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this._paramList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n >= 0 && n < this.getRowCount()) {
            Parameter parameter = this._paramList.get(n);
            switch (n2) {
                case 0: {
                    object = parameter.getParamName();
                    break;
                }
                case 1: {
                    object = parameter.getType().getTypeName();
                    break;
                }
                case 2: {
                    object = parameter.getMode();
                    break;
                }
                case 3: {
                    object = parameter.getValue();
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Parameter parameter = this._paramList.get(n);
        parameter.setValue(object);
    }

    public void editParam(String string, String string2, String string3) {
        for (Parameter parameter : this._paramList) {
            if (!parameter.getVarName().equals(string)) continue;
            parameter.setUnFormattedValue(string2);
            if (string3 == null) continue;
            parameter.editType(string3);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this._headers.length;
    }

    @Override
    public String getColumnName(int n) {
        return this._headers[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 3) {
            Object var3_3 = null;
            if (n >= 0 && n < this.getRowCount()) {
                Parameter parameter = this._paramList.get(n);
                if (parameter.getType().getSqlType() != 2 && parameter.getType().getSqlType() != 12 && parameter.getType().getSqlType() != 91) {
                    return false;
                }
                return parameter.getMode().equals(Mode.IN_OUT) || parameter.getMode().equals(Mode.IN);
            }
        }
        return false;
    }

    public Parameter getParameter(int n) {
        return this._paramList.get(n);
    }

    private PlsqlType[] _resolveParsedProgram(PlsqlRoot plsqlRoot, Procedure procedure) {
        PlsqlSubprg[] plsqlSubprgArray;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        PlsqlSubprg plsqlSubprg = null;
        if (n > 0 && (plsqlSubprgArray = ParamTableModel._findProgramsByName(plsqlNodeArray[0], procedure.getName())).length > 0) {
            PlsqlSubprg plsqlSubprg2;
            int n2 = procedure.getOverload();
            plsqlSubprg = n2 == 0 ? plsqlSubprgArray[0] : (this.matches(plsqlSubprg2 = plsqlSubprgArray[n2 - 1]) ? plsqlSubprg2 : this.findMatch(plsqlSubprgArray));
        }
        return plsqlSubprg != null ? ParamTableModel.getTypeList(plsqlSubprg) : new PlsqlType[]{};
    }

    private static PlsqlSubprg[] _findProgramsByName(PlsqlNode plsqlNode, String string) {
        PlsqlSubprg[] plsqlSubprgArray = null;
        switch (plsqlNode.getTreeKind()) {
            case 18: {
                PlsqlNode[] plsqlNodeArray = ((PlsqlPkg)plsqlNode).getDeclarations();
                plsqlSubprgArray = new PlsqlSubprg[plsqlNodeArray.length];
                int n = 0;
                for (int i = 0; i < plsqlNodeArray.length; ++i) {
                    if (plsqlNodeArray[i].getTreeKind() != 17 || !string.equals(ParamTableModel.convertName(((PlsqlSubprg)plsqlNodeArray[i]).getName().toString()))) continue;
                    plsqlSubprgArray[n++] = (PlsqlSubprg)plsqlNodeArray[i];
                }
                if (n >= plsqlSubprgArray.length) break;
                PlsqlSubprg[] plsqlSubprgArray2 = plsqlSubprgArray;
                plsqlSubprgArray = new PlsqlSubprg[n];
                System.arraycopy(plsqlSubprgArray2, 0, plsqlSubprgArray, 0, n);
                break;
            }
            case 17: {
                PlsqlName plsqlName = ((PlsqlSubprg)plsqlNode).getName();
                if (!string.equals(ParamTableModel.convertName(plsqlName.toString()))) break;
                plsqlSubprgArray = new PlsqlSubprg[]{(PlsqlSubprg)plsqlNode};
                break;
            }
        }
        return plsqlSubprgArray != null ? plsqlSubprgArray : new PlsqlSubprg[]{};
    }

    private boolean matches(PlsqlSubprg plsqlSubprg) {
        Parameter parameter;
        boolean bl = false;
        Parameter[] parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        if (plsqlType == null == ((parameter = parameterArray.length > 0 && parameterArray[0].isReturn() ? parameterArray[0] : null) == null)) {
            Parameter[] parameterArray2;
            PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
            if (parameter != null && (parameterArray = new Parameter[(parameterArray2 = parameterArray).length - 1]).length > 0) {
                System.arraycopy(parameterArray2, 1, parameterArray, 0, parameterArray.length);
            }
            if (plsqlVariableArray.length == parameterArray.length && ParamTableModel.paramsMatch(plsqlType, parameter != null ? parameter.getType() : null)) {
                bl = true;
                for (int i = 0; i < plsqlVariableArray.length; ++i) {
                    if (ParamTableModel.paramsMatch(plsqlVariableArray[i].getVariableType(), parameterArray[i].getType())) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private PlsqlSubprg findMatch(PlsqlSubprg[] plsqlSubprgArray) {
        for (int i = 0; i < plsqlSubprgArray.length; ++i) {
            if (!this.matches(plsqlSubprgArray[i])) continue;
            return plsqlSubprgArray[i];
        }
        return null;
    }

    private static boolean paramsMatch(PlsqlType plsqlType, Type type) {
        int n;
        String string;
        String string2;
        boolean bl = true;
        if (plsqlType != null && type != null && (string2 = type.getTypeName()) != null && !string2.equals(string = ParamTableModel.convertName(plsqlType.getTypeName().toString())) && !type.isOutputSupported() && (n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(n + 1);
            bl = string2.equals(string);
        }
        return bl;
    }

    private static PlsqlType[] getTypeList(PlsqlSubprg plsqlSubprg) {
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
        PlsqlType[] plsqlTypeArray = new PlsqlType[plsqlVariableArray.length + (plsqlType != null ? 1 : 0)];
        int n = 0;
        if (plsqlType != null) {
            plsqlTypeArray[n++] = plsqlType;
        }
        for (int i = 0; i < plsqlVariableArray.length; ++i) {
            plsqlTypeArray[n++] = plsqlVariableArray[i].getVariableType();
        }
        return plsqlTypeArray;
    }

    private static Query getQuery(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(ParamTableModel.class.getClassLoader(), "oracle/dbtools/raptor/runner/source.xml"));
        Query query = queryXMLSupport.getQuery("params", connection);
        return QueryUtils.promoteToDba((Query)query, (Connection)connection);
    }

    private static boolean unknownType(String string) {
        return string == null || FAKE_NAMES.contains(string.toUpperCase());
    }

    private static String validateTypeName(String string) {
        String string2 = BOGUS_NAMES.get(string = string.toString());
        return string2 != null ? string2 : string;
    }

    private static String convertName(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    private static PlsqlTypedef[] getTypedefs(PlsqlRoot plsqlRoot) {
        PlsqlNode plsqlNode;
        int n;
        PlsqlTypedef[] plsqlTypedefArray = null;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n2 = n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        if (n > 0 && (plsqlNode = plsqlNodeArray[0]).getTreeKind() == 18) {
            PlsqlNode[] plsqlNodeArray2 = ((PlsqlPkg)plsqlNode).getDeclarations();
            plsqlTypedefArray = new PlsqlTypedef[plsqlNodeArray2.length];
            int n3 = 0;
            block3: for (int i = 0; i < plsqlNodeArray2.length; ++i) {
                switch (plsqlNodeArray2[i].getTreeKind()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        plsqlTypedefArray[n3++] = (PlsqlTypedef)plsqlNodeArray2[i];
                        continue block3;
                    }
                }
            }
            if (n3 < plsqlTypedefArray.length) {
                PlsqlTypedef[] plsqlTypedefArray2 = plsqlTypedefArray;
                plsqlTypedefArray = new PlsqlTypedef[n3];
                if (n3 > 0) {
                    System.arraycopy(plsqlTypedefArray2, 0, plsqlTypedefArray, 0, n3);
                }
            }
        }
        return plsqlTypedefArray != null ? plsqlTypedefArray : new PlsqlTypedef[]{};
    }

    private static String getQualifiedName(String string, Procedure procedure) {
        if (0 < string.indexOf(46)) {
            return string;
        }
        String string2 = Service.addDoubleQuote((String)procedure.getOwner());
        String string3 = Service.addDoubleQuote((String)procedure.getPackage());
        String string4 = null;
        if (0 < string.indexOf(46)) {
            string4 = Service.addDoubleQuote((String)Service.handleMixedCase((String)string.substring(0, string.indexOf(46))));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ModelUtil.hasLength((String)string2) && !string2.equals(string4)) {
            stringBuilder.append(string2).append('.');
        }
        if (ModelUtil.hasLength((String)string3) && !string3.equals(string4)) {
            stringBuilder.append(string3).append('.');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    static {
        BOGUS_NAMES.put("PL/SQL BOOLEAN", "BOOLEAN");
    }
}

