/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.PinningTracker;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public final class PlSqlBufferPinning
extends NodeListener {
    private Map<Node, ReadTextBuffer> pinnedBuffers = new TreeMap<Node, ReadTextBuffer>();

    public void nodeOpened(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        TextBuffer textBuffer = ((PlSqlNode)node).acquireTextBuffer();
        this.pinnedBuffers.put(node, (ReadTextBuffer)textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("AUTOPINPLSQLEDITORS").booleanValue() && !node.getURL().getFile().contains("anon_block")) {
            PinningTracker.pinNode(node);
        }
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        ((PlSqlNode)node).releaseTextBuffer();
        this.pinnedBuffers.remove(node);
        PinningTracker.unpinNode(node);
    }
}

