/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.io.File;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.AbstractDisplayModelParser;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.plsql.PLSQLStatusDisplay;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.PLSQL;
import oracle.dbtools.raptor.newscriptrunner.ScriptCommandListener;
import oracle.dbtools.raptor.plsql.ExternalUpdateTracker;
import oracle.dbtools.raptor.plsql.FindHighlightListener;
import oracle.dbtools.raptor.plsql.PLSQLDependencies;
import oracle.dbtools.raptor.plsql.PLSQLDetails;
import oracle.dbtools.raptor.plsql.PLSQLErrors;
import oracle.dbtools.raptor.plsql.PLSQLGrants;
import oracle.dbtools.raptor.plsql.PLSQLProfiles;
import oracle.dbtools.raptor.plsql.PLSQLReferences;
import oracle.dbtools.raptor.plsql.PinningTracker;
import oracle.dbtools.raptor.plsql.PlSqlBufferPinning;
import oracle.dbtools.raptor.plsql.SaveAsCommand;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageModule;
import oracle.dbtools.raptor.plsql.structure.LocationListener;
import oracle.dbtools.raptor.runner.debug.RaptorDebuggingHelper;
import oracle.dbtools.raptor.runner.debug.jdi.DBJDIFileSystemHelperFactory;
import oracle.dbtools.raptor.runner.debug.probe.RaptorDebugProbeConnector;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeListener;
import oracle.ide.util.MenuSpec;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideri.util.Product;
import oracle.jdevimpl.debugger.support.DebugFactory;

public class PLSQLAddin
implements Addin {
    private static final String ACCELERATOR_FILE = "oracle/dbtools/raptor/plsql/accelerators.xml";
    private Map<String, Integer> editorNums = new HashMap<String, Integer>();
    static Map<Element, Float> cachedWeights = new HashMap<Element, Float>();

    public void initialize() {
        DebugFactory.registerDebugConnector((int)2, RaptorDebugProbeConnector.class, (String)RaptorDebugProbeConnector.getVersion());
        DBJDIFileSystemHelperFactory.initialize();
        RaptorDebuggingHelper.initialize();
        new PLSQLLanguageModule();
        this.addPlSqlEditorListener();
        this.addPlSqlNodeListener();
        PLSQL.registerListener((ScriptCommandListener)new PLSQLStatusDisplay());
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("GRANTS_EDITOR_LABEL"), PLSQLGrants.class, null, 9, -0.1f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("DEPENDENCIES_EDITOR_LABEL"), PLSQLDependencies.class, null, 9, -0.2f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("REFERENCES_EDITOR_LABEL"), PLSQLReferences.class, null, 9, -0.3f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("ERRORS_EDITOR_LABEL"), PLSQLErrors.class, null, 9, -0.4f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("DETAILS_EDITOR_LABEL"), PLSQLDetails.class, null, 9, -0.5f);
        PLSQLAddin.registerEditor(DBDevExtensionResource.getString("PROFILES_EDITOR_LABEL"), PLSQLProfiles.class, null, 11, -0.6f);
        this.customEditors();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        Node.addNodeListenerForTypeHierarchy(DatabaseSourceNode.class, (NodeListener)new ExternalUpdateTracker());
        IdeAction ideAction = IdeActions.getFileSaveAsAction();
        ideAction.setCommand(MetaClass.newMetaClass(SaveAsCommand.class));
        if (Product.isRaptor()) {
            PlSqlFeatures.setSupportedBreadcrumbs((boolean)DBConfig.getInstance().getBoolean("SUPPORTEDBREADCRUMBS"));
            PlSqlFeatures.setSupportedGutterNavigation((boolean)DBConfig.getInstance().getBoolean("SUPPORTEDGUTTERNAVIGATION"));
            PlSqlFeatures.setSupportedQuickDocumentation((boolean)DBConfig.getInstance().getBoolean("SUPPORTEDQUICKDOCUMENTATION"));
            PlSqlFeatures.setSupportedSyncSpecAndBody((boolean)DBConfig.getInstance().getBoolean("SUPPORTEDSYNKSPECANDBODY"));
            PlSqlFeatures.setSupportedTestQuery((boolean)DBConfig.getInstance().getBoolean("SUPPORTEDTESTQUERY"));
        }
    }

    private void customEditors() {
        XMLParser xMLParser = new XMLParser();
        List<String> list = DBConfig.getInstance().getExtensions("EDITOR");
        if (list != null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            for (String string : list) {
                try {
                    if (string == null) continue;
                    xMLParser.processXML(MetaURLReference.createURLReference((File)new File(string), (ClassLoader)classLoader));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void registerEditor(final String string, final Class<? extends Editor> clazz, final String string2, final int n, final float f) {
        EditorAddin editorAddin = new EditorAddin(){

            public Class<? extends Editor> getEditorClass() {
                return clazz;
            }

            public MenuSpec getMenuSpecification() {
                return new MenuSpec(string, null);
            }

            public boolean isDefault() {
                return (double)f > 0.99;
            }

            public float getEditorWeight(Element element) {
                if (cachedWeights.containsKey(element)) {
                    return cachedWeights.get(element).floatValue();
                }
                if (element instanceof PlSqlNode) {
                    PlSqlNode plSqlNode = (PlSqlNode)element;
                    String string4 = plSqlNode.getObjectType();
                    if (string4 != null && "BLOCK".equals(string4) || string2 != null && string4 != null && !string4.equalsIgnoreCase(string2) || plSqlNode.getURL().toString().startsWith("sqldev.migration")) {
                        cachedWeights.put(element, Float.valueOf(Float.NaN));
                        return Float.NaN;
                    }
                    String string22 = plSqlNode.getConnectionName();
                    if (Connections.getInstance().isOracle(string22)) {
                        try {
                            Connection connection = Connections.getInstance().getConnection(string22);
                            Properties properties = Connections.getInstance().getConnectionInfo(string22);
                            if (properties == null) {
                                cachedWeights.put(element, Float.valueOf(Float.NaN));
                                return Float.NaN;
                            }
                            String string3 = properties.getProperty("driver");
                            if ((0.99 < (double)f || "oracle.jdbc.OracleDriver".equals(string3)) && connection.getMetaData().getDatabaseMajorVersion() >= n) {
                                cachedWeights.put(element, Float.valueOf(f));
                                return f;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                cachedWeights.put(element, Float.valueOf(Float.NaN));
                return Float.NaN;
            }
        };
        EditorManager.getEditorManager().registerDynamic(editorAddin);
    }

    private void addPlSqlEditorListener() {
        EditorManager.getEditorManager().addEditorListener((EditorListener)new PinningTracker());
        if (RaptorExtensionConstants.isStandAlone()) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new FindHighlightListener());
            EditorManager.getEditorManager().addEditorListener((EditorListener)new LocationListener());
        }
    }

    private void addPlSqlNodeListener() {
        Node.addNodeListenerForType(PlSqlNode.class, (NodeListener)new PlSqlBufferPinning());
    }

    private final class XMLParser
    extends AbstractDisplayModelParser {
        private XMLParser() {
        }

        @Override
        protected void registerEditor(String string, String string2, DisplayModel displayModel, MetaClass<? extends Editor> metaClass) {
            if (this.isPlSql(string2)) {
                try {
                    if (PLSQLAddin.this.editorNums.size() > 5) {
                        return;
                    }
                    Integer n = (Integer)PLSQLAddin.this.editorNums.get(displayModel.getName());
                    if (n != null) {
                        return;
                    }
                    n = PLSQLAddin.this.editorNums.size() + 1;
                    PLSQLAddin.this.editorNums.put(displayModel.getName(), n);
                    Class<?> clazz = Class.forName("oracle.dbtools.raptor.plsql.CustomInfoPanel" + n);
                    Field field = clazz.getDeclaredField("query");
                    field.set(null, displayModel.getQuery().toString());
                    Field field2 = clazz.getDeclaredField("isPivoted");
                    field2.setAccessible(true);
                    field2.setBoolean(null, "true".equalsIgnoreCase(displayModel.getExtAttributes().get("vertical")));
                    PLSQLAddin.registerEditor(displayModel.getName(), clazz, string2, 9, -10.0f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean isPlSql(String string) {
            if (string == null) {
                return true;
            }
            for (String string2 : AbstractDisplayModelParser.getTypesForNode("PlSqlBaseNode")) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

