/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.jsoneditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.cloud.navigator.CloudViewerDetail;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.cloud.BasicCloudEditorAddin;
import oracle.dbtools.raptor.oviewer.jsoneditor.JSONComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class JSONBasedEditor
extends AsynchronousViewerEditor
implements Controller,
PropertyChangeListener {
    public static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_JSON_Editor");
    private JPanel _panel;
    private JSONComponent _comp;
    private CloudObject _co;
    private IdeAction _refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("XMLBasedEditor.2"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this);

    public JSONBasedEditor() {
        this._refreshAction.addController((Controller)this);
    }

    @Override
    protected JComponent createViewerUI() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new GridBagLayout());
            String string = ((BasicCloudEditorAddin)this.getEditorAddin()).getTabName();
            this._co = (CloudObject)((ViewerNode)this.getContext().getNode()).getDBObject().getNode();
            CloudViewerDetail cloudViewerDetail = this._co.getViewers().get(string);
            this._comp = new JSONComponent(cloudViewerDetail, this._co.getConnectionName());
            this._comp.addPropertyChangeListener(this);
            this._panel.add((Component)this._comp.getDisplayUI(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
            JSONBasedEditor.invokeLaterAfterRepaint((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSONBasedEditor.this.buildToolbar();
                }
            });
        }
        return this._panel;
    }

    @Override
    protected void updateContent(boolean bl) {
        String string = ((BasicCloudEditorAddin)this.getEditorAddin()).getTabName();
        this._co = (CloudObject)((ViewerNode)this.getContext().getNode()).getDBObject().getNode();
        CloudViewerDetail cloudViewerDetail = this._co.getViewers().get(string);
        this._comp.setDetails(cloudViewerDetail);
        this._comp.refresh();
    }

    private void buildToolbar() {
        ToolButton toolButton = null;
        toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._refreshAction);
        toolButton.setName(this._refreshAction.getValue("Name").toString());
        ((Toolbar)this.getFixedTopMargin()).putClientProperty((Object)"EditableGridControl.NO_REFRESH_CMD", (Object)Boolean.TRUE.toString());
    }

    @Override
    protected void cleanUp() {
        this._panel = null;
        this._comp = null;
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_EDITOR_CMD_ID) {
            this.updateContent(true);
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    @Override
    public Object getPrintable() {
        return this._panel;
    }

    public Component getScrollableLeftMargin() {
        if (this._comp != null) {
            return this._comp.getScrollableLeftMargin();
        }
        return super.getScrollableLeftMargin();
    }

    public Component getScrollableTopMargin() {
        if (this._comp != null) {
            return this._comp.getScrollableTopMargin();
        }
        return super.getScrollableTopMargin();
    }

    public Object getEditorAttribute(String string) {
        boolean bl = this.isScrollable();
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return 31;
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return 21;
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    private boolean isScrollable() {
        return this._comp == null || this._comp.isScrollable();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isScrollable()) {
            if (string.equals("scrollable_left_margin")) {
                this.firePropertyChangeEvent("scrollable_left_margin", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (string.equals("scrollable_top_margin")) {
                this.firePropertyChangeEvent("scrollable_top_margin", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deplobjectviewer_html");
    }
}

