/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.iterator;

import oracle.dbtools.raptor.controls.grid.IRowIterator;
import oracle.dbtools.raptor.onsd.connection.NSConnection;
import oracle.dbtools.raptor.onsd.connection.NSConnections;
import oracle.dbtools.raptor.onsd.iterator.AbstractOnsdIterator;
import oracle.dbtools.raptor.onsd.iterator.OnsdTableChildrenIterator;
import oracle.dbtools.raptor.onsd.iterator.OnsdTableColumnIterator;
import oracle.dbtools.raptor.onsd.iterator.OnsdTableDetailsIterator;
import oracle.dbtools.raptor.onsd.iterator.OnsdTableIndexIterator;
import oracle.dbtools.raptor.onsd.iterator.OnsdTableRowIterator;
import oracle.kv.KVStore;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import oracle.kv.table.TableIteratorOptions;

public class OnsdQueryFactory {
    private static OnsdQueryFactory INSTANCE = null;
    public static final String GET_TABLES = "getTables";
    public static final String GET_TABLE_ROWS = "getRows";
    public static final String GET_TABLE_COLUMNS = "getColumns";
    public static final String GET_TABLE_DETAILS = "getDetails";
    public static final String GET_TABLE_CHILDREN = "getChildTables";
    public static final String GET_TABLE_INDEXES = "getIndexes";

    private OnsdQueryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnsdQueryFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<OnsdQueryFactory> clazz = OnsdQueryFactory.class;
        synchronized (OnsdQueryFactory.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new OnsdQueryFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public IRowIterator getTableIterator(String string, String string2, String string3) {
        return this.getTableRowIterator(string, string2, string3, null, null);
    }

    public IRowIterator getTableRowIterator(String string, String string2, String string3, MultiRowOptions multiRowOptions, TableIteratorOptions tableIteratorOptions) {
        Object object;
        Table table = null;
        try {
            object = NSConnections.getInstance().getConnection(string, false);
            KVStore kVStore = ((NSConnection)object).getStore();
            TableAPI tableAPI = kVStore.getTableAPI();
            table = tableAPI.getTable(string3);
            String string4 = table.getFullName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.getTableIterator(string2, table, multiRowOptions, tableIteratorOptions);
        if (object != null) {
            ((AbstractOnsdIterator)object).setConnectionName(string);
            ((AbstractOnsdIterator)object).setIteratorUniqueName(string + string3 + string2);
        }
        return object;
    }

    private AbstractOnsdIterator getTableIterator(String string, Table table, MultiRowOptions multiRowOptions, TableIteratorOptions tableIteratorOptions) {
        if (GET_TABLE_ROWS.equals(string)) {
            PrimaryKey primaryKey = table.createPrimaryKey();
            return new OnsdTableRowIterator(primaryKey, multiRowOptions, tableIteratorOptions);
        }
        if (GET_TABLE_COLUMNS.equals(string)) {
            return new OnsdTableColumnIterator(table);
        }
        if (GET_TABLE_CHILDREN.equals(string)) {
            return new OnsdTableChildrenIterator(table);
        }
        if (GET_TABLE_DETAILS.equals(string)) {
            return new OnsdTableDetailsIterator(table);
        }
        if (GET_TABLE_INDEXES.equals(string)) {
            return new OnsdTableIndexIterator(table);
        }
        return null;
    }
}

