/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.onsd.connection;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import oracle.dbtools.raptor.onsd.connection.NSConnectionException;
import oracle.dbtools.raptor.onsd.connection.NSConnectionInfo;
import oracle.javatools.util.ModelUtil;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.ReauthenticateHandler;

public class NSConnection {
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final int DEFAULT_DB_PORT = 5000;
    private NSConnectionInfo m_info;
    private State m_state = State.CLOSED;
    private ReentrantLock m_lock;
    private KVStore m_store;

    NSConnection(NSConnectionInfo nSConnectionInfo) {
        this.m_info = nSConnectionInfo;
        this.m_lock = new ReentrantLock();
    }

    public boolean isOpen() {
        return this.m_state == State.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws NSConnectionException {
        if (this.m_state == State.OPEN) {
            return;
        }
        this.m_lock.lock();
        try {
            PasswordCredentials passwordCredentials;
            Properties properties;
            URL uRL;
            Boolean bl;
            String string = this.m_info.getUsername();
            char[] cArray = this.m_info.getPassword();
            String string2 = this.m_info.getHosts();
            String string3 = this.m_info.getStoreName();
            NSConnectionInfo.TransportInfo transportInfo = this.m_info.getTransportInfo();
            NSConnectionInfo.SecurityInfo securityInfo = this.m_info.getSecurityInfo();
            if (transportInfo != null) {
                bl = transportInfo.getUseSSL();
                uRL = transportInfo.getKeyFile();
            } else {
                bl = false;
                uRL = null;
            }
            URL uRL2 = securityInfo != null ? securityInfo.getWalletDir() : null;
            URL uRL3 = securityInfo != null ? securityInfo.getPWDFile() : null;
            URL uRL4 = securityInfo != null ? securityInfo.getPropertyFile() : null;
            KVStoreConfig kVStoreConfig = new KVStoreConfig(string3, this.getHostsList(string2));
            if (bl != null && bl.booleanValue()) {
                properties = new Properties();
                properties.setProperty("oracle.kv.transport", "ssl");
                properties.setProperty("oracle.kv.ssl.trustStore", this.getLocalFileName(uRL));
                properties.setProperty("oracle.kv.ssl.protocols", "TLSv1.2,TLSv1.1,TLSv1");
                properties.setProperty("oracle.kv.ssl.hostnameVerifier", "dnmatch(CN=NoSQL)");
            } else {
                properties = null;
            }
            if (cArray != null && cArray.length > 0) {
                passwordCredentials = new PasswordCredentials(ModelUtil.hasLength((String)string) ? string : "", cArray);
            } else {
                passwordCredentials = null;
                if (ModelUtil.hasLength((String)string)) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("oracle.kv.auth.username", string);
                }
            }
            if (uRL4 != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("oracle.kv.security", this.getLocalFileName(uRL4));
            }
            if (uRL2 != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("oracle.kv.auth.wallet.dir", this.getLocalFileName(uRL2));
            }
            if (uRL3 != null) {
                if (properties == null) {
                    properties = new Properties();
                }
                properties.setProperty("oracle.kv.auth.pwdfile.file", this.getLocalFileName(uRL3));
            }
            if (properties != null) {
                kVStoreConfig.setSecurityProperties(properties);
            }
            this.m_store = KVStoreFactory.getStore((KVStoreConfig)kVStoreConfig, (LoginCredentials)passwordCredentials, (ReauthenticateHandler)new ReauthenticateHandler(){

                public void reauthenticate(KVStore kVStore) {
                    kVStore.login((LoginCredentials)passwordCredentials);
                }
            });
            this.m_state = State.OPEN;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    private String[] getHostsList(String string) {
        String[] stringArray;
        if (string != null && string.length() > 0) {
            stringArray = string.split("[,]");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2 != null) {
                        if (string2.length() <= 0) continue;
                        stringArray[i] = string2 = string2.trim();
                        String[] stringArray2 = string2.split("[:]");
                        if (stringArray2 != null) {
                            for (int j = 0; j < stringArray2.length; ++j) {
                                if (stringArray2[j] == null) continue;
                                stringArray2[j] = stringArray2[j].trim();
                            }
                            if (stringArray2.length != 1) continue;
                            stringArray[i] = stringArray2[0] + ":" + 5000;
                            continue;
                        }
                        stringArray[i] = "";
                        continue;
                    }
                    stringArray[i] = "";
                }
            } else {
                stringArray = new String[]{""};
            }
        } else {
            stringArray = new String[]{""};
        }
        return stringArray;
    }

    void close() {
        if (this.isOpen()) {
            this.m_lock.lock();
            try {
                this.m_store.close();
                this.m_state = State.CLOSED;
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    public KVStore getStore() {
        return this.m_store;
    }

    public NSConnectionInfo getConnectionInfo() {
        return this.m_info;
    }

    private String getLocalFileName(URL uRL) {
        String string = null;
        if (uRL != null) {
            string = uRL.getPath();
            try {
                string = URLDecoder.decode(string, "utf-8");
                string = new File(string).getPath();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string;
    }

    private static enum State {
        OPEN,
        CLOSED;

    }
}

