/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.util.Service;
import oracle.ide.ExtensionRegistry;
import oracle.ideri.util.Product;

public class Project {
    private static Logger logger = Logger.getLogger(Project.class.getName());
    private Map<String, String> db2file = new HashMap<String, String>();
    private static Project instance = null;
    private static String persistedAs = "project.qbql";
    private File file = null;
    private long timeStamp = -1L;
    static final String header = "[fileURL dbURL]\n";
    List<LexerToken> src;
    int table;
    int content;
    int value;
    String prior = null;

    public static Project getInstance() {
        Object object;
        if (instance == null) {
            instance = new Project();
        }
        try {
            object = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID());
            String string = ((URL)object).getPath();
            Project.instance.file = new File(string + persistedAs);
        }
        catch (Exception exception) {
            logger.warning("Failed to obtain URL for the product system directory");
        }
        if (Project.instance.timeStamp == -1L || Project.instance.file.lastModified() != Project.instance.timeStamp) {
            try {
                object = Service.readFile((String)Project.instance.file.getPath());
                instance.init((String)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.warning("Project file doesn't exist. Creating new one.");
                instance.save(header);
            }
            catch (Exception exception) {
                logger.severe("Failed to read persisted project " + exception.getMessage());
            }
        }
        return instance;
    }

    public String getFileURL(String string) {
        return this.db2file.get(string);
    }

    public Set<String> getDbURL(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (!DBConfig.getInstance().getBoolean("LINKDBWITHFILESOURCES").booleanValue()) {
            return hashSet;
        }
        for (String string2 : this.db2file.keySet()) {
            if (!string.equals(this.db2file.get(string2))) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public void save(String string, String string2) {
        this.db2file.put(string2, string);
        String string3 = header;
        for (String string4 : this.db2file.keySet()) {
            string3 = string3 + " \"" + this.getFileURL(string4) + "\" \"" + string4 + "\"\n";
        }
        this.save(string3);
    }

    private void save(String string) {
        Object object;
        String string2 = "";
        try {
            object = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID());
            string2 = ((URL)object).getPath();
        }
        catch (Exception exception) {
            logger.warning("Failed to obtain URL for the product system directory");
        }
        try {
            object = new FileOutputStream(string2 + persistedAs);
            ((FileOutputStream)object).write(string.getBytes());
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            logger.severe("Failed to save project " + exception.getMessage());
        }
        this.timeStamp = this.file.lastModified();
    }

    public static void main(String[] stringArray) {
        Project project = Project.getInstance();
    }

    private static Set<RuleTuple> tableRules() throws Exception {
        String string = Service.readFile(Project.class, (String)"table.grammar");
        List list = LexerToken.parse((String)string);
        ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
        return treeSet;
    }

    private void init(String string) {
        Earley earley = null;
        try {
            earley = new Earley(Project.tableRules()){

                protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                    LexerToken lexerToken = list.get(n);
                    if (lexerToken.type == Token.DQUOTED_STRING) {
                        return true;
                    }
                    return lexerToken.type == Token.IDENTIFIER;
                }
            };
        }
        catch (Exception exception) {
            logger.severe("Failed to read grammar file");
            return;
        }
        this.table = (Integer)earley.symbolIndexes.get("table");
        this.content = (Integer)earley.symbolIndexes.get("content");
        this.value = (Integer)earley.symbolIndexes.get("value");
        this.src = LexerToken.parse((String)string);
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(this.src, matrix);
        ParseNode parseNode = earley.forest(this.src, matrix);
        if (parseNode.topLevel != null) {
            System.err.println("*** Parse Error in assertions file ***");
            return;
        }
        try {
            this.table(parseNode);
        }
        catch (Exception exception) {
            System.err.println("*** Error in recursive descent parser ***");
        }
    }

    private void table(ParseNode parseNode) throws Exception {
        if (!parseNode.contains(this.table)) {
            throw new Exception("Not a tab");
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(this.content) && !parseNode2.contains(this.value)) continue;
            this.content(parseNode2);
            break;
        }
    }

    private void content(ParseNode parseNode) throws Exception {
        if (parseNode.from + 1 == parseNode.to) {
            if (this.prior == null) {
                this.prior = parseNode.content(this.src);
            } else {
                Object object = parseNode.content(this.src);
                if (((String)object).startsWith("\"")) {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                }
                if (this.prior.startsWith("\"")) {
                    this.prior = this.prior.substring(1, this.prior.length() - 1);
                }
                this.db2file.put((String)object, this.prior);
                this.prior = null;
            }
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            this.content(parseNode2);
        }
    }
}

