/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesFoldersController;
import oracle.dbtools.raptor.navigator.folders.DatabasesTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;

public class DatabasesFoldersMenuListener
implements ContextMenuListener {
    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        final Element[] elementArray = context.getSelection();
        if (DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, DatabaseConnection.class, true)) {
            NavigatorTreeNode navigatorTreeNode;
            NavigatorTreeNode navigatorTreeNode2;
            NavigatorTreeNode navigatorTreeNode3 = NavigatorContext.getFirstNavigatorTreeNodeFromContext(context);
            final NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
            NavigatorTreeNode navigatorTreeNode4 = (NavigatorTreeNode)navigatorTreeNode3.getParent();
            if (navigatorTreeNode4.getElement() instanceof Databases) {
                navigatorTreeNode2 = navigatorTreeNode4;
                navigatorTreeNode = null;
            } else {
                navigatorTreeNode = navigatorTreeNode4;
                navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode4.getParent();
            }
            String string = navigatorTreeNode != null ? ((DatabasesFolder)navigatorTreeNode.getElement()).getName() : null;
            IdeAction ideAction = IdeAction.find((int)DatabasesFoldersController.CONNECTION_CATEGORY_ID);
            String string2 = (String)ideAction.getValue("Name");
            Integer n = (Integer)ideAction.getValue("MnemonicKey");
            JMenu jMenu = contextMenu.createSubMenu(string2, n);
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)IdeAction.find((int)DatabasesFoldersController.NEW_CONNECTION_CATEGORY_ID));
            jMenu.add(jMenuItem);
            if (navigatorTreeNode2 instanceof DatabasesTreeNode) {
                final DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode2;
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(databasesTreeNode.getFolderNames()));
                if (string != null) {
                    treeSet.remove(string);
                }
                if (treeSet.size() > 0) {
                    jMenu.addSeparator();
                    for (final String string3 : treeSet) {
                        ToggleAction toggleAction = new ToggleAction(string3, null){

                            public void actionPerformed(ActionEvent actionEvent) {
                                databasesTreeNode.updateFolder(navigatorTree, string3, elementArray);
                            }
                        };
                        jMenu.add(contextMenu.createMenuItem(toggleAction));
                    }
                }
            }
            contextMenu.add((Component)jMenu, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            ideAction = IdeAction.find((int)DatabasesFoldersController.REMOVE_FROM_FOLDER_ID);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)ideAction);
            jMenuItem.setEnabled(string != null);
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        } else if (DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, DatabasesFolder.class, false)) {
            IdeAction ideAction = IdeAction.find((int)DatabasesFoldersController.DISCONNECT_CONNECTION_FROM_FOLDER_ID);
            ideAction.setEnabled(this.isAnyconnectionOpen(elementArray));
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            ideAction = IdeAction.find((int)DatabasesFoldersController.RENAME_CONNECTION_CATEGORY_ID);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            ideAction = IdeAction.find((int)DatabasesFoldersController.REMOVE_CONNECTION_CATEGORY_ID);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        } else if (DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, Databases.class, false)) {
            IdeAction ideAction = IdeAction.find((int)DatabasesFoldersController.DISCONNECT_CONNECTION_FROM_FOLDER_ID);
            ideAction.setEnabled(this.isAnyconnectionOpen(elementArray));
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        }
    }

    private boolean isAnyconnectionOpen(Element[] elementArray) {
        block3: {
            block2: {
                if (!DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, Databases.class, false)) break block2;
                String[] stringArray = Connections.getInstance().getConnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!Connections.getInstance().isConnectionOpen(stringArray[i])) continue;
                    return true;
                }
                break block3;
            }
            if (!DatabasesFoldersMenuListener.isValidSelectionOfType(elementArray, DatabasesFolder.class, false)) break block3;
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            Iterator iterator = databasesFolder.getChildren();
            while (iterator.hasNext()) {
                String string = ((DatabaseConnection)iterator.next()).getQualifiedConnectionName();
                if (!Connections.getInstance().isConnectionOpen(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isValidSelectionOfType(Element[] elementArray, Class<? extends Element> clazz, boolean bl) {
        if (elementArray != null && elementArray.length > 0 && (bl || elementArray.length == 1)) {
            for (Element element : elementArray) {
                if (clazz.isAssignableFrom(element.getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

