/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.XmlBaseElement;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.xml.parser.v2.XMLNode;

abstract class XmlFolderOwner
extends XmlBaseElement
implements NavigatorXmlElements {
    private static final String ELEMENT_FOLDER = "folder";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final String ATTRIBUTE_REQUIRES_PARENT = "requiresParent";
    private static final String ATTRIBUTE_TREEONLY = "treeonly";
    protected double m_weight = 100.0;
    protected boolean m_includesSyns;
    private boolean m_treeOnly;
    private boolean m_requiresParent;
    protected NavigatorDescriptor m_desc;
    private List<XmlFolderImpl> m_folders;

    abstract boolean isIncludesSynonyms();

    public abstract String getType();

    protected XmlFolderOwner(String string, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        super(string);
        this.m_desc = navigatorDescriptor;
        this.m_treeOnly = Boolean.valueOf(XmlNavigatorUtils.getAttributeValue("", ATTRIBUTE_TREEONLY, xMLNode));
        this.m_requiresParent = Boolean.valueOf(XmlNavigatorUtils.getAttributeValue("", ATTRIBUTE_REQUIRES_PARENT, xMLNode));
        String string2 = XmlNavigatorUtils.getAttributeValue("", ATTRIBUTE_WEIGHT, xMLNode);
        if (string2 != null) {
            try {
                this.m_weight = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.initFolders(xMLNode);
    }

    public double getWeight() {
        return this.m_weight;
    }

    protected DatabaseFolder[] getFoldersImpl() {
        return this.m_folders.toArray(new XmlFolderImpl[0]);
    }

    protected NavigatorDescriptor getNavigatorDescriptor() {
        return this.m_desc;
    }

    private void initFolders(XMLNode xMLNode) {
        if (this.m_folders == null) {
            this.m_folders = new ArrayList<XmlFolderImpl>();
            for (XMLNode xMLNode2 : XmlNavigatorUtils.getElements(ELEMENT_FOLDER, xMLNode)) {
                this.m_folders.add(new XmlFolderImpl(this, this.m_desc, xMLNode2));
            }
        }
    }

    public boolean isTreeOnly() {
        return this.m_treeOnly;
    }

    public boolean requiresParentObject() {
        return this.m_requiresParent;
    }
}

