/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.BaseElement;
import oracle.dbtools.raptor.navigator.db.model.Catalogs;
import oracle.dbtools.raptor.navigator.db.model.DBSchemas;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemasImpl;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public final class QueryFactory
implements NavigatorXmlElements {
    private static final Map<String, QueryFactory> s_factories = new HashMap<String, QueryFactory>();
    private String m_dbType;
    private List<Pair<String, ObjectType>> m_types = new ArrayList<Pair<String, ObjectType>>();
    private List<Pair<String, ObjectCategory>> m_categories = new ArrayList<Pair<String, ObjectCategory>>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;

    public static synchronized QueryFactory getFactory(String string, String string2) {
        QueryFactory queryFactory = s_factories.get(string2);
        if (queryFactory == null) {
            queryFactory = QueryFactory.createFactory(string, string2);
            s_factories.put(string2, queryFactory);
        }
        return queryFactory;
    }

    private static QueryFactory createFactory(String string, String string2) {
        return new QueryFactory(string, string2);
    }

    private QueryFactory(String string, String string2) {
        this.m_dbType = string2;
        Iterator<NavigatorDescriptor> iterator = NavigatorHook.getHookInstance(string).getNavigatorDescriptors();
        while (iterator.hasNext()) {
            NavigatorDescriptor navigatorDescriptor = iterator.next();
            try {
                XmlCatalogsImpl xmlCatalogsImpl;
                XmlSchemasImpl xmlSchemasImpl = navigatorDescriptor.getSchemasDescriptor();
                if (xmlSchemasImpl != null && ModelUtil.areEqual((Object)xmlSchemasImpl.getDBType(), (Object)string2)) {
                    this.m_schemas = xmlSchemasImpl;
                }
                if ((xmlCatalogsImpl = navigatorDescriptor.getCatalogsDescriptor()) != null && ModelUtil.areEqual((Object)xmlCatalogsImpl.getDBType(), (Object)string2)) {
                    this.m_catalogs = xmlCatalogsImpl;
                }
                for (Pair<String, ObjectType> pair : navigatorDescriptor.getObjectTypes()) {
                    if (!ModelUtil.areEqual((Object)((ObjectType)pair.second).getDBType(), (Object)string2)) continue;
                    this.m_types.add(pair);
                }
                for (Pair pair : navigatorDescriptor.getCategories()) {
                    if (!ModelUtil.areEqual((Object)((ObjectCategory)pair.second).getDBType(), (Object)string2)) continue;
                    this.m_categories.add((Pair<String, ObjectCategory>)pair);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public ObjectType[] listTypes() {
        int n = 0;
        ObjectType[] objectTypeArray = new ObjectType[this.m_types.size()];
        for (Pair<String, ObjectType> pair : this.m_types) {
            objectTypeArray[n++] = (ObjectType)pair.second;
        }
        return objectTypeArray;
    }

    public ObjectCategory[] listCategories() {
        int n = 0;
        ObjectCategory[] objectCategoryArray = new ObjectCategory[this.m_types.size()];
        for (Pair<String, ObjectCategory> pair : this.m_categories) {
            objectCategoryArray[n++] = (ObjectCategory)pair.second;
        }
        return objectCategoryArray;
    }

    public ObjectType[] listTypes(String string) {
        int n = 0;
        ObjectType[] objectTypeArray = new ObjectType[this.m_types.size()];
        for (Pair<String, ObjectType> pair : this.m_types) {
            if (!ModelUtil.areEqual((Object)string, (Object)pair.first)) continue;
            objectTypeArray[n++] = (ObjectType)pair.second;
        }
        if (n < objectTypeArray.length) {
            ObjectType[] objectTypeArray2 = objectTypeArray;
            objectTypeArray = new ObjectType[n];
            System.arraycopy(objectTypeArray2, 0, objectTypeArray, 0, n);
        }
        return objectTypeArray;
    }

    public ObjectCategory[] listCategories(String string) {
        int n = 0;
        ObjectCategory[] objectCategoryArray = new ObjectCategory[this.m_categories.size()];
        for (Pair<String, ObjectCategory> pair : this.m_categories) {
            if (!ModelUtil.areEqual((Object)string, (Object)pair.first)) continue;
            objectCategoryArray[n++] = (ObjectCategory)pair.second;
        }
        if (n < objectCategoryArray.length) {
            ObjectCategory[] objectCategoryArray2 = objectCategoryArray;
            objectCategoryArray = new ObjectCategory[n];
            System.arraycopy(objectCategoryArray2, 0, objectCategoryArray, 0, n);
        }
        return objectCategoryArray;
    }

    public ObjectType getObjectType(String string) {
        for (Pair<String, ObjectType> pair : this.m_types) {
            ObjectType objectType = (ObjectType)pair.second;
            if (!ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return objectType;
        }
        return null;
    }

    public BaseElement getObjectType(String string, String string2) {
        for (Pair<String, ObjectType> pair : this.m_types) {
            ObjectType objectType = (ObjectType)pair.second;
            if (!ModelUtil.areEqual((Object)pair.first, (Object)string2) || !ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return objectType;
        }
        return null;
    }

    ObjectCategory getCategoryForType(String string) {
        for (Pair<String, ObjectType> pair : this.m_types) {
            ObjectType objectType = (ObjectType)pair.second;
            if (!ModelUtil.areEqual((Object)objectType.getType(), (Object)string)) continue;
            return this.getCategory((String)pair.first);
        }
        return null;
    }

    ObjectCategory getCategoryForCategory(String string) {
        for (Pair<String, ObjectCategory> pair : this.m_categories) {
            ObjectCategory objectCategory = (ObjectCategory)pair.second;
            if (!ModelUtil.areEqual((Object)objectCategory.getType(), (Object)string)) continue;
            return this.getCategory((String)pair.first);
        }
        return null;
    }

    private ObjectCategory getCategory(String string) {
        for (Pair<String, ObjectCategory> pair : this.m_categories) {
            ObjectCategory objectCategory = (ObjectCategory)pair.second;
            if (!ModelUtil.areEqual((Object)objectCategory.getType(), (Object)string)) continue;
            return objectCategory;
        }
        return null;
    }

    DBSchemas getSchemas() {
        return this.m_schemas;
    }

    Catalogs getCatalogs() {
        return this.m_catalogs;
    }

    public String getType() {
        return null;
    }
}

