/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.BaseElement;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.AbstractObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.ResourceProvider;
import oracle.dbtools.raptor.navigator.db.xml.XmlCatalogsImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlCategoryType;
import oracle.dbtools.raptor.navigator.db.xml.XmlConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemasImpl;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.javatools.util.Pair;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public final class NavigatorDescriptor
implements NavigatorXmlElements,
ResourceProvider {
    private String m_navType;
    private ResourceBundle m_bundle;
    private Map<String, ConnectionType> m_types;
    private List<Pair<String, ObjectType>> m_objectTypes = new ArrayList<Pair<String, ObjectType>>();
    private List<Pair<String, ObjectCategory>> m_categories = new ArrayList<Pair<String, ObjectCategory>>();
    private XmlSchemasImpl m_schemas;
    private XmlCatalogsImpl m_catalogs;
    private ClassLoader m_loader;

    public static NavigatorDescriptor createDescriptor(String string, XMLDocument xMLDocument, ClassLoader classLoader) {
        assert (xMLDocument != null);
        assert (classLoader != null);
        XMLNode xMLNode = (XMLNode)XMLHelper.getChildNode((Node)xMLDocument, (String)"navigator");
        if (xMLNode != null) {
            return new NavigatorDescriptor(string, xMLNode, classLoader);
        }
        return null;
    }

    private NavigatorDescriptor(String string, XMLNode xMLNode, ClassLoader classLoader) {
        Object object;
        String string2;
        String string3;
        XMLNode[] xMLNodeArray;
        this.m_loader = classLoader;
        this.m_navType = string;
        String string4 = XMLHelper.getAttributeNode((Node)xMLNode, (String)"RESOURCE_FILE");
        if (string4 != null) {
            this.m_bundle = ResourceBundle.getBundle(string4, Locale.getDefault(), this.m_loader);
        }
        if ((xMLNodeArray = XMLHelper.getChildNodes((Node)xMLNode, (String)"connection")) != null) {
            this.m_types = new HashMap<String, ConnectionType>();
            for (int i = 0; i < xMLNodeArray.length; ++i) {
                XmlConnectionType xmlConnectionType = new XmlConnectionType(xMLNodeArray[i], this);
                this.m_types.put(xmlConnectionType.getType(), xmlConnectionType);
            }
        } else {
            this.m_types = Collections.emptyMap();
        }
        for (XMLNode xMLNode2 : XmlNavigatorUtils.getElements("/navigator/objectType", xMLNode)) {
            String string5 = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode2);
            if (string5 == null) continue;
            string3 = XmlNavigatorUtils.getAttributeValue("", "connType", xMLNode2);
            if ("SCHEMAS".equals(string5)) {
                this.m_schemas = new XmlSchemasImpl(string3, this, xMLNode2);
                continue;
            }
            if ("CATALOGS".equals(string5)) {
                this.m_catalogs = new XmlCatalogsImpl(string3, this, xMLNode2);
                continue;
            }
            string2 = XmlNavigatorUtils.getAttributeValue("", "category", xMLNode2);
            object = this.createObjectType(string3, string5, xMLNode2);
            this.m_objectTypes.add((Pair<String, ObjectType>)new Pair((Object)string2, object));
        }
        XMLNode[] xMLNodeArray2 = XmlNavigatorUtils.getElements("/navigator/categoryType", xMLNode);
        if (xMLNodeArray2 != null) {
            for (XMLNode xMLNode2 : xMLNodeArray2) {
                string3 = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode2);
                if (string3 == null) continue;
                string2 = XmlNavigatorUtils.getAttributeValue("", "connType", xMLNode2);
                object = XmlNavigatorUtils.getAttributeValue("", "category", xMLNode2);
                this.m_categories.add((Pair<String, ObjectCategory>)new Pair(object, (Object)this.createObjectCategory(string2, string3, xMLNode2)));
            }
        }
    }

    private BaseElement createObjectType(String string, String string2, XMLNode xMLNode) {
        ObjectType objectType = new XmlObjectType(string, string2, this, xMLNode);
        String string3 = XmlNavigatorUtils.getAttributeValue("", "implementationClass", xMLNode);
        if (string3 != null) {
            try {
                Class<?> clazz = Class.forName(string3, true, this.m_loader);
                assert (AbstractObjectType.class.isAssignableFrom(clazz));
                AbstractObjectType abstractObjectType = (AbstractObjectType)clazz.newInstance();
                abstractObjectType.setDelegate((XmlObjectType)objectType);
                objectType = abstractObjectType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectType;
    }

    private ObjectCategory createObjectCategory(String string, String string2, XMLNode xMLNode) {
        return new XmlCategoryType(string, string2, this, xMLNode);
    }

    @Override
    public ClassLoader getDescriptorClassLoader() {
        return this.m_loader;
    }

    @Override
    public String getResource(String string) {
        try {
            return this.m_bundle != null ? this.m_bundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "No Value for key:" + string);
            return string;
        }
    }

    public Collection<Pair<String, ObjectType>> getObjectTypes() {
        return this.m_objectTypes;
    }

    public Collection<Pair<String, ObjectCategory>> getCategories() {
        return this.m_categories;
    }

    XmlSchemasImpl getSchemasDescriptor() {
        return this.m_schemas;
    }

    XmlCatalogsImpl getCatalogsDescriptor() {
        return this.m_catalogs;
    }

    public ConnectionType getConnectionType(String string) {
        return this.m_types.get(string);
    }

    public Iterator<ConnectionType> getConnectionTypes() {
        return this.m_types.values().iterator();
    }
}

