/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.value;

import java.util.Deque;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.util.Pair;
import oracle.dbtools.raptor.metrics.listener.DXJobEvent;
import oracle.dbtools.raptor.metrics.value.ItemChangeAdapter;

class DerivativeChangeAdapter
extends ItemChangeAdapter<Number> {
    private final DoubleProperty property;
    private final int smoothBy;
    private final Deque<Pair<Long, Number>> deque;
    private Number currentValue;

    DerivativeChangeAdapter(DoubleProperty doubleProperty, int n) {
        this.property = doubleProperty;
        this.smoothBy = n;
        this.deque = new LinkedList<Pair<Long, Number>>();
    }

    @Override
    void onChange(long l, Number number) {
        this.currentValue = number;
    }

    @Override
    public void onJobEnd(DXJobEvent dXJobEvent) {
        Platform.runLater(() -> this.setDerivative(dXJobEvent.getTStamp()));
    }

    private void setDerivative(long l) {
        if (this.deque.size() == this.smoothBy) {
            Pair<Long, Number> pair = this.deque.removeLast();
            double d = (double)(l - (Long)pair.getKey()) / 1000.0;
            double d2 = this.currentValue.doubleValue() - ((Number)pair.getValue()).doubleValue();
            this.property.setValue((Number)(d2 / d));
            this.setAvailable();
        }
        this.deque.addFirst((Pair<Long, Number>)new Pair((Object)l, (Object)this.currentValue));
    }
}

