/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXSourceType;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeUpdate;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.JobTypeElement;

class SourceTypeElement
extends CacheElement {
    private final StringProperty pathProperty;
    private final LongProperty defaultMinimumIntervalProperty;

    SourceTypeElement(CacheElementLookup cacheElementLookup, URI uRI, DXSourceType dXSourceType) {
        super(cacheElementLookup, uRI);
        this.mergeJobTypes(cacheElementLookup, dXSourceType.getJobTypes());
        this.sortChildren();
        this.pathProperty = new SimpleStringProperty(DXIds.getPath(uRI));
        this.defaultMinimumIntervalProperty = new SimpleLongProperty(dXSourceType.getDefaultMinimumInterval());
    }

    void mergeJobTypes(CacheElementLookup cacheElementLookup, Map<URI, DXJobType> map) {
        for (URI uRI : map.keySet()) {
            DXJobType dXJobType = map.get(uRI);
            this.addChildElement(new JobTypeElement(cacheElementLookup, uRI, dXJobType));
        }
    }

    void update(DXSourceTypeUpdate dXSourceTypeUpdate) {
        this.defaultMinimumIntervalProperty.set(dXSourceTypeUpdate.getDefaultMinimumInterval());
    }

    StringProperty pathProperty() {
        return this.pathProperty;
    }

    LongProperty defaultMinimumIntervalProperty() {
        return this.defaultMinimumIntervalProperty;
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_JOB_TYPE_PATH"), cellDataFeatures -> ((JobTypeElement)cellDataFeatures.getValue()).pathProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_DEFAULT_DISABLED"), cellDataFeatures -> ((JobTypeElement)cellDataFeatures.getValue()).defaultDisabledProperty().asString()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_DEFAULT_INTERVAL"), cellDataFeatures -> ((JobTypeElement)cellDataFeatures.getValue()).defaultMinimumIntervalProperty().asString()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/package_folder.png";
    }

    public String toString() {
        return (String)this.pathProperty.get();
    }
}

