/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TableColumn;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.listener.DXSourceType;
import oracle.dbtools.raptor.metrics.ui.CacheElement;
import oracle.dbtools.raptor.metrics.ui.CacheElementLookup;
import oracle.dbtools.raptor.metrics.ui.ConnectionElement;
import oracle.dbtools.raptor.metrics.ui.SourceTypeElement;
import oracle.dbtools.raptor.metrics.ui.SourceTypesElement;

class ConnectionTypeElement
extends CacheElement {
    private final SourceTypesElement sourceTypesElement;
    private final StringProperty connectionTypeNameProperty;

    ConnectionTypeElement(CacheElementLookup cacheElementLookup, URI uRI) {
        super(cacheElementLookup, uRI);
        this.sourceTypesElement = new SourceTypesElement(cacheElementLookup);
        this.addChildElement(this.sourceTypesElement);
        this.connectionTypeNameProperty = new SimpleStringProperty(DXIds.getConnectionTypeName(this.getId()));
    }

    StringProperty connectionTypeNameProperty() {
        return this.connectionTypeNameProperty;
    }

    void addSourceType(URI uRI, DXSourceType dXSourceType) {
        this.sourceTypesElement.addChildElement(new SourceTypeElement(this.getLookup(), uRI, dXSourceType));
    }

    void addConnection(URI uRI, String string) {
        this.addChildElement(new ConnectionElement(this.getLookup(), uRI, string));
    }

    @Override
    Comparator<CacheElement> getChildElementComparator() {
        return (cacheElement, cacheElement2) -> {
            if (cacheElement == this.sourceTypesElement) {
                return -1;
            }
            if (cacheElement2 == this.sourceTypesElement) {
                return 1;
            }
            return cacheElement.toString().compareTo(cacheElement2.toString());
        };
    }

    @Override
    List<TableColumn<? extends CacheElement, String>> getTableColumns() {
        ArrayList<TableColumn<? extends CacheElement, String>> arrayList = new ArrayList<TableColumn<? extends CacheElement, String>>();
        arrayList.add(this.createTableLeadColumn(MetricsResources.get("METRICS_UI_CONNECTION_NAME"), cellDataFeatures -> ((ConnectionElement)cellDataFeatures.getValue()).connectionDisplayNameProperty()));
        arrayList.add(this.createTableColumn(MetricsResources.get("METRICS_UI_CONNECTION_TYPE"), cellDataFeatures -> ((ConnectionElement)cellDataFeatures.getValue()).connectionTypeNameProperty()));
        return arrayList;
    }

    @Override
    String getIconPath() {
        return "/oracle/dbtools/raptor/images/connections_folder.png";
    }

    public String toString() {
        return (String)this.connectionTypeNameProperty.get();
    }
}

