/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.item.StringType;
import oracle.dbtools.raptor.metrics.item.TableItemType;
import oracle.dbtools.raptor.metrics.item.TableValue;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;

class TableItem
extends Item {
    private final TableItemType itemType;
    private Map<String, DXTableChanges.Row> rowMap;
    private DXTableChanges tableChanges;

    TableItem(TableItemType tableItemType, Job job) {
        super(job);
        this.itemType = tableItemType;
        this.rowMap = Collections.emptyMap();
    }

    @Override
    public TableItemType getItemType() {
        return this.itemType;
    }

    @Override
    protected DXTableChanges getChangeObject() {
        ArrayList<DXTableChanges.Row> arrayList = new ArrayList<DXTableChanges.Row>(this.rowMap.values());
        List<DXTableChanges.Cell> list = Collections.emptyList();
        List<Object> list2 = Collections.emptyList();
        return new DXTableChanges(arrayList, list, list2);
    }

    @Override
    protected DXTableChanges getIncrementalChangeObject() {
        return this.tableChanges;
    }

    @Override
    protected void update(Map<String, List<?>> map) {
        List<?> list = map.get(this.itemType.getKeyColumn());
        if (list != null) {
            StringType stringType = new StringType();
            Map<String, DXTableChanges.Row> map2 = this.rowMap;
            HashMap<String, DXTableChanges.Row> hashMap = new HashMap<String, DXTableChanges.Row>();
            ArrayList<DXTableChanges.Row> arrayList = new ArrayList<DXTableChanges.Row>();
            ArrayList<DXTableChanges.Cell> arrayList2 = new ArrayList<DXTableChanges.Cell>();
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            boolean bl = false;
            int n = 0;
            for (Object object : list) {
                Object object2;
                DXTableChanges.Row object3 = map2.get(object);
                if (object3 == null) {
                    String string = stringType.toValue(object);
                    object2 = this.createNewRow(string, map, n);
                    arrayList.add((DXTableChanges.Row)object2);
                    hashMap.put(string, (DXTableChanges.Row)object2);
                    bl = true;
                } else {
                    boolean bl2 = false;
                    for (TableValue tableValue : this.itemType.getTableValues()) {
                        String string = tableValue.getName();
                        List<?> list2 = map.get(tableValue.getColumn());
                        Object t = tableValue.getValueType().toValue(list2.get(n));
                        if (object3.getCellValue(string).equals(t)) continue;
                        arrayList2.add(new DXTableChanges.Cell(stringType.toValue(object), string, t));
                        bl2 = true;
                    }
                    if (bl2) {
                        object2 = stringType.toValue(object);
                        DXTableChanges.Row row = this.createNewRow((String)object2, map, n);
                        hashMap.put(stringType.toValue(object), row);
                        bl = true;
                    } else {
                        hashMap.put(stringType.toValue(object), object3);
                    }
                }
                ++n;
            }
            HashSet<?> hashSet = new HashSet(list);
            for (String string : map2.keySet()) {
                if (hashSet.contains(string)) continue;
                arrayList3.add(string);
                bl = true;
            }
            if (bl) {
                this.tableChanges = new DXTableChanges(arrayList, arrayList2, arrayList3);
                this.markChanged();
            } else {
                this.tableChanges = null;
            }
            this.rowMap = hashMap;
        } else {
            logger.log(Level.WARNING, "Zero length array received for column ''{0}''", this.itemType.getKeyColumn());
        }
    }

    private DXTableChanges.Row createNewRow(String string, Map<String, List<?>> map, int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (TableValue tableValue : this.itemType.getTableValues()) {
            String string2 = tableValue.getName();
            List<?> list = map.get(tableValue.getColumn());
            if (list != null) {
                hashMap.put(string2, tableValue.getValueType().toValue(list.get(n)));
                continue;
            }
            hashMap.put(string2, null);
        }
        return new DXTableChanges.Row(string, hashMap);
    }
}

