/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.item.PrimitiveItemType;

abstract class PrimitiveItem<T>
extends Item {
    private T value;

    PrimitiveItem(Job job) {
        super(job);
    }

    @Override
    public abstract PrimitiveItemType<T> getItemType();

    protected T getChangeObject() {
        return this.value;
    }

    @Override
    protected void update(Map<String, List<?>> map) {
        String string = ((PrimitiveItemType)this.getItemType()).getColumn();
        List<?> list = map.get(string);
        if (list != null && list.size() > 0) {
            Object object = null;
            try {
                object = this.getValue(list.get(0));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to convert '' + column + '' from type ''{0}'' to type ''{1}''", new Object[]{list.get(0).getClass().getName(), ((PrimitiveItemType)this.getItemType()).getChangeClass().getName()});
            }
            boolean bl = object != null ? !object.equals(this.value) : this.value != null;
            this.value = object;
            if (bl) {
                this.markChanged();
            }
        } else {
            logger.log(Level.WARNING, "Zero length array received for column ''{0}''", string);
        }
    }

    protected T getValue(Object object) {
        return ((PrimitiveItemType)this.getItemType()).convert(object);
    }
}

