/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Engine;

abstract class PropertyService {
    private final Map<String, String> transientValues = new HashMap<String, String>();

    PropertyService() {
    }

    String get(URI uRI, String string, String string2) {
        String string3 = this.getKey(uRI, string);
        String string4 = this.getProperty(string3);
        if (string4 == null) {
            string4 = string2 != null ? string2 : "";
        }
        return string4;
    }

    long get(URI uRI, String string, long l) {
        long l2;
        String string2 = this.getKey(uRI, string);
        String string3 = this.getProperty(string2);
        if (string3 != null) {
            try {
                l2 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Engine.logger.log(Level.WARNING, "error loading property '" + string2 + "'", numberFormatException);
                l2 = l;
            }
        } else {
            l2 = l;
        }
        return l2;
    }

    double get(URI uRI, String string, double d) {
        double d2;
        String string2 = this.getKey(uRI, string);
        String string3 = this.getProperty(string2);
        if (string3 != null) {
            try {
                d2 = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Engine.logger.log(Level.WARNING, "error loading property '" + string2 + "'", numberFormatException);
                d2 = d;
            }
        } else {
            d2 = d;
        }
        return d2;
    }

    boolean get(URI uRI, String string, boolean bl) {
        String string2 = this.getKey(uRI, string);
        String string3 = this.getProperty(string2);
        boolean bl2 = string3 != null ? Boolean.parseBoolean(string3) : bl;
        return bl2;
    }

    void set(URI uRI, String string, String string2, boolean bl) {
        String string3 = this.getKey(uRI, string);
        this.setProperty(string3, string2 != null ? string2 : "", bl);
    }

    void set(URI uRI, String string, long l, boolean bl) {
        String string2 = this.getKey(uRI, string);
        this.setProperty(string2, Long.toString(l), bl);
    }

    void set(URI uRI, String string, double d, boolean bl) {
        String string2 = this.getKey(uRI, string);
        this.setProperty(string2, Double.toString(d), bl);
    }

    void set(URI uRI, String string, boolean bl, boolean bl2) {
        String string2 = this.getKey(uRI, string);
        this.setProperty(string2, Boolean.toString(bl), bl2);
    }

    abstract String getPersistentProperty(String var1);

    abstract void setPersistentProperty(String var1, String var2);

    private String getKey(URI uRI, String string) {
        return uRI.toString() + "#" + string;
    }

    private String getProperty(String string) {
        String string2 = this.transientValues.get(string);
        if (string2 == null) {
            string2 = this.getPersistentProperty(string);
        }
        return string2;
    }

    private void setProperty(String string, String string2, boolean bl) {
        if (bl) {
            this.setPersistentProperty(string, string2);
            this.transientValues.remove(string);
        } else {
            this.transientValues.put(string, string2);
        }
    }
}

