/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class LoaderHelper
implements XMLHelper {
    private final String resourcePath;
    private final InputStream inputStream;
    private final Map<String, Class<?>> classMap;

    LoaderHelper(String string, InputStream inputStream) {
        this.resourcePath = string;
        this.inputStream = inputStream;
        this.classMap = new HashMap();
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XMLElement load() {
        XMLElement xMLElement = null;
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse(this.inputStream);
            XMLDocument xMLDocument = dOMParser.getDocument();
            xMLElement = (XMLElement)xMLDocument.getDocumentElement();
            if (!xMLElement.getTagName().equals("Metrics")) {
                throw new DXException("root element does not have tag name 'Metrics'");
            }
            for (XMLElement xMLElement2 : this.getChildElements(xMLElement, "import")) {
                String string = this.getStringAttribute(xMLElement2, "class");
                try {
                    Class<?> clazz = Class.forName(string);
                    String string2 = string.replace(clazz.getPackage().getName(), "");
                    if (string2.startsWith(".")) {
                        string2 = string2.substring(1);
                    }
                    this.classMap.put(string2, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DXException("imported class not found: " + string);
                    return xMLElement;
                }
            }
        }
        catch (IOException | DXException | SAXException exception) {
            throw new DXException(exception);
        }
    }

    @Override
    public List<XMLElement> getChildElements(XMLElement xMLElement, String string) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        NodeList nodeList = xMLElement.getChildrenByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof XMLElement)) continue;
            arrayList.add((XMLElement)node);
        }
        return arrayList;
    }

    @Override
    public List<XMLElement> getChildElements(XMLElement xMLElement) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        NodeList nodeList = xMLElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof XMLElement)) continue;
            arrayList.add((XMLElement)node);
        }
        return arrayList;
    }

    @Override
    public String getStringAttribute(XMLElement xMLElement, String string) {
        return this.getStringAttribute(xMLElement, string, null);
    }

    @Override
    public String getStringAttribute(XMLElement xMLElement, String string, String string2) {
        String string3 = null;
        String string4 = xMLElement.getAttribute(string);
        if (!string4.equals("")) {
            string3 = string4;
        } else if (string2 != null) {
            string3 = string2;
        } else {
            throw new DXException("attribute '" + string + "' must be specified for an '" + xMLElement.getTagName() + "' element");
        }
        return string4;
    }

    @Override
    public Long getLongAttribute(XMLElement xMLElement, String string) {
        return this.getLongAttribute(xMLElement, string, null);
    }

    @Override
    public Long getLongAttribute(XMLElement xMLElement, String string, Long l) {
        Long l2 = null;
        String string2 = xMLElement.getAttribute(string);
        if (!string2.equals("")) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXException("'" + string + "', when specified, must be an integer", numberFormatException);
            }
        } else if (l != null) {
            l2 = l;
        } else {
            throw new DXException("attribute '" + string + "' must be specified for '" + xMLElement.getTagName() + "' elements");
        }
        return l2;
    }

    @Override
    public Double getDoubleAttribute(XMLElement xMLElement, String string) {
        return this.getDoubleAttribute(xMLElement, string, null);
    }

    @Override
    public Double getDoubleAttribute(XMLElement xMLElement, String string, Double d) {
        Double d2 = null;
        String string2 = xMLElement.getAttribute(string);
        if (!string2.equals("")) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXException("'" + string + "', when specified, must be a double", numberFormatException);
            }
        } else if (d != null) {
            d2 = d;
        } else {
            throw new DXException("attribute '" + string + "' must be specified for '" + xMLElement.getTagName() + "' elements");
        }
        return d2;
    }

    @Override
    public Boolean getBooleanAttribute(XMLElement xMLElement, String string) {
        return this.getBooleanAttribute(xMLElement, string, null);
    }

    @Override
    public Boolean getBooleanAttribute(XMLElement xMLElement, String string, Boolean bl) {
        Boolean bl2 = null;
        String string2 = xMLElement.getAttribute(string);
        if (!string2.equals("")) {
            bl2 = Boolean.parseBoolean(string2);
        } else if (bl != null) {
            bl2 = bl;
        } else {
            throw new DXException("attribute '" + string + "' must be specified for '" + xMLElement.getTagName() + "' elements");
        }
        return bl2;
    }

    @Override
    public <B> B instantiateTypeObject(Class<B> clazz, String string) {
        B b = null;
        Class<?> clazz2 = this.classMap.get(string);
        if (clazz2 != null) {
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new DXException("'" + clazz2.getName() + "' does not extend '" + clazz.getName() + "'");
            }
            try {
                b = (B)clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new DXException("error instantiating type class '" + clazz2 + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DXException("no access to type class '" + clazz2 + "'", illegalAccessException);
            }
        }
        return b;
    }
}

