/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.EngineNotification;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.engine.PropertyService;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.XMLHelper;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXItemType;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXJobTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;
import oracle.xml.parser.v2.XMLElement;

public abstract class JobType {
    private Engine engine;
    private SourceType sourceType;
    private String jobPath;
    private final Map<String, ItemType> itemTypeMap = new HashMap<String, ItemType>();
    private long defaultMinimumInterval;
    private boolean defaultDisabled;
    protected static final Logger logger = Logger.getLogger(JobType.class.getName());

    protected JobType() {
    }

    public URI getJobTypeId() {
        return DXIds.newTypeId(this.sourceType.getSourceTypeId(), this.jobPath);
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getJobPath() {
        return this.jobPath;
    }

    protected Map<String, ItemType> itemTypeMap() {
        return this.itemTypeMap;
    }

    protected void load(SourceType sourceType, XMLHelper xMLHelper, XMLElement xMLElement) {
        this.sourceType = sourceType;
        this.jobPath = xMLHelper.getStringAttribute(xMLElement, "path");
        this.defaultDisabled = xMLHelper.getBooleanAttribute(xMLElement, "disabled", false);
        this.defaultMinimumInterval = xMLHelper.getLongAttribute(xMLElement, "minimumInterval", 5000L);
        for (XMLElement xMLElement2 : xMLHelper.getChildElements(xMLElement)) {
            if (this.isChildElementConsumedBySubclass(xMLElement2)) continue;
            ItemType itemType = xMLHelper.instantiateTypeObject(ItemType.class, xMLElement2.getTagName());
            if (itemType != null) {
                itemType.load(this, xMLHelper, xMLElement2);
                this.itemTypeMap().put(itemType.getItemPath(), itemType);
                continue;
            }
            logger.log(Level.SEVERE, "unrecognised item type element encounted for resource ''{0}''", xMLHelper.getResourcePath());
        }
    }

    protected abstract String[] consumedChildTagNames();

    boolean isDefaultDisabled() {
        assert (Engine.isMetricsThread());
        return this.defaultDisabled;
    }

    long getDefaultMinimumInterval() {
        assert (Engine.isMetricsThread());
        return this.defaultMinimumInterval;
    }

    long getMinimumInterval(Job job) {
        assert (Engine.isMetricsThread());
        return this.engine.getPropertyService().get(job.getJobId(), "minimumInterval", this.defaultMinimumInterval);
    }

    void setMinimumInterval(Job job, long l, boolean bl) {
        assert (Engine.isMetricsThread());
        if (l != job.getMinimumInterval()) {
            this.engine.getPropertyService().set(job.getJobId(), "minimumInterval", l, bl);
            job.setMinimumInterval(l);
            this.sendIntervalChangeNotification(job);
        }
    }

    void setDefaultMinimumInterval(long l, boolean bl) {
        assert (Engine.isMetricsThread());
        if (l != this.defaultMinimumInterval) {
            this.defaultMinimumInterval = l;
            this.sendIntervalChangeNotification();
            PropertyService propertyService = this.engine.getPropertyService();
            propertyService.set(this.getJobTypeId(), "defaultMinimumInterval", l, bl);
        }
    }

    boolean isDisabled(Job job) {
        assert (Engine.isMetricsThread());
        return this.engine.getPropertyService().get(job.getJobId(), "disabled", this.defaultDisabled);
    }

    void setDisabled(Job job, boolean bl, boolean bl2) {
        assert (Engine.isMetricsThread());
        if (bl != job.getState().disabled()) {
            this.engine.getPropertyService().set(job.getJobId(), "disabled", bl, bl2);
            if (bl) {
                this.engine.addEvent(job.createDisable());
            } else {
                this.engine.addEvent(job.createEnable());
            }
        }
    }

    void setDefaultDisabled(boolean bl, boolean bl2) {
        assert (Engine.isMetricsThread());
        if (bl != this.defaultDisabled) {
            this.defaultDisabled = bl;
            this.sendDefaultDisableNotification();
            PropertyService propertyService = this.engine.getPropertyService();
            propertyService.set(this.getJobTypeId(), "defaultDisabled", bl, bl2);
        }
    }

    void attach(Engine engine) {
        assert (Engine.isMetricsThread());
        this.engine = engine;
        PropertyService propertyService = engine.getPropertyService();
        URI uRI = this.getJobTypeId();
        this.defaultDisabled = propertyService.get(uRI, "defaultDisabled", this.defaultDisabled);
        this.defaultMinimumInterval = propertyService.get(uRI, "defaultMinimumInterval", this.defaultMinimumInterval);
    }

    private boolean isChildElementConsumedBySubclass(XMLElement xMLElement) {
        boolean bl = false;
        String[] stringArray = this.consumedChildTagNames();
        if (stringArray != null && stringArray.length != 0) {
            String string = xMLElement.getTagName();
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void sendIntervalChangeNotification() {
        this.engine.addNotification(new EngineNotification<DXJobTypeUpdate>(this.engine){

            @Override
            DXJobTypeUpdate createEvent() {
                return this.createJobTypeUpdateEvent(DXEvent.Type.JOB_TYPE_DEFAULT_INTERVAL, JobType.this);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXJobTypeUpdate dXJobTypeUpdate) {
                dXEngineListener.onDefaultMinimumIntervalChange(dXJobTypeUpdate);
            }
        });
    }

    private void sendIntervalChangeNotification(final Job job) {
        this.engine.addNotification(new EngineNotification<DXJobUpdate>(this.engine){

            @Override
            DXJobUpdate createEvent() {
                return this.createJobUpdateEvent(DXEvent.Type.JOB_INTERVAL, job);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXJobUpdate dXJobUpdate) {
                dXEngineListener.onMinimumIntervalChange(dXJobUpdate);
            }
        });
    }

    private void sendDefaultDisableNotification() {
        this.engine.addNotification(new EngineNotification<DXJobTypeUpdate>(this.engine){

            @Override
            DXJobTypeUpdate createEvent() {
                return this.createJobTypeUpdateEvent(JobType.this.defaultDisabled ? DXEvent.Type.JOB_DISABLE : DXEvent.Type.JOB_ENABLE, JobType.this);
            }

            @Override
            void callListener(DXEngineListener dXEngineListener, DXJobTypeUpdate dXJobTypeUpdate) {
                if (JobType.this.defaultDisabled) {
                    dXEngineListener.onDefaultDisable(dXJobTypeUpdate);
                } else {
                    dXEngineListener.onDefaultEnable(dXJobTypeUpdate);
                }
            }
        });
    }

    DXJobType createJobTypeEvent() {
        HashMap<URI, DXItemType> hashMap = new HashMap<URI, DXItemType>();
        for (ItemType itemType : this.itemTypeMap().values()) {
            hashMap.put(itemType.getItemTypeId(), itemType.createItemTypeEvent());
        }
        return new DXJobType(this.defaultMinimumInterval, this.defaultDisabled, hashMap);
    }
}

