/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.Item;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.Job;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.Source;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.listener.DXEngineBind;
import oracle.dbtools.raptor.metrics.listener.DXEngineListener;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXItem;
import oracle.dbtools.raptor.metrics.listener.DXItemType;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJob;
import oracle.dbtools.raptor.metrics.listener.DXJobType;
import oracle.dbtools.raptor.metrics.listener.DXJobTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXJobUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSource;
import oracle.dbtools.raptor.metrics.listener.DXSourceAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceType;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeAdd;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeMerge;
import oracle.dbtools.raptor.metrics.listener.DXSourceTypeUpdate;
import oracle.dbtools.raptor.metrics.listener.DXSourceUpdate;
import oracle.dbtools.raptor.metrics.listener.DXUnbind;

abstract class EngineNotification<E extends DXEvent>
extends Notification {
    private final Engine engine;

    EngineNotification(Engine engine) {
        this.engine = engine;
    }

    @Override
    void execute() {
        Set<DXEngineListener> set = this.engine.engineListeners();
        if (set.size() > 0) {
            this.callListeners(this.createEvent());
        }
    }

    void callListeners(E e) {
        for (DXEngineListener dXEngineListener : this.engine.engineListeners()) {
            this.callListener(dXEngineListener, e);
        }
    }

    abstract E createEvent();

    abstract void callListener(DXEngineListener var1, E var2);

    DXError createErrorEvent(DXEvent.Type type, DXException dXException) {
        return new DXError(type, null, dXException);
    }

    DXUnbind createUnbindEvent(DXEvent.Type type) {
        return new DXUnbind(type, null);
    }

    DXEngineBind createEngineBindEvent(DXEvent.Type type, Engine engine) {
        HashMap<URI, DXSourceType> hashMap = new HashMap<URI, DXSourceType>();
        for (SourceType object : engine.sourceTypeMap().values()) {
            hashMap.put(object.getSourceTypeId(), this.createSourceTypeObject(object));
        }
        HashMap hashMap2 = new HashMap();
        for (Source source : engine.sourceMap().values()) {
            hashMap2.put(source.getSourceId(), this.createSourceObject(source));
        }
        return new DXEngineBind(type, hashMap, hashMap2);
    }

    DXSourceTypeAdd createSourceTypeAddEvent(DXEvent.Type type, SourceType sourceType) {
        return new DXSourceTypeAdd(type, sourceType.getSourceTypeId(), this.createSourceTypeObject(sourceType));
    }

    DXSourceTypeMerge createSourceTypeMergeEvent(DXEvent.Type type, SourceType sourceType) {
        return new DXSourceTypeMerge(type, sourceType.getSourceTypeId(), this.createJobTypeMap(sourceType));
    }

    DXSourceTypeUpdate createSourceTypeUpdateEvent(DXEvent.Type type, SourceType sourceType) {
        return new DXSourceTypeUpdate(type, sourceType.getSourceTypeId(), sourceType.getDefaultMinimumInterval());
    }

    DXJobTypeUpdate createJobTypeUpdateEvent(DXEvent.Type type, JobType jobType) {
        return new DXJobTypeUpdate(type, jobType.getJobTypeId(), jobType.getDefaultMinimumInterval(), jobType.isDefaultDisabled());
    }

    DXSourceAdd createSourceAddEvent(DXEvent.Type type, Source source) {
        return new DXSourceAdd(type, source.getSourceId(), this.createSourceObject(source));
    }

    DXSourceUpdate createSourceUpdateEvent(DXEvent.Type type, Source source) {
        return new DXSourceUpdate(type, source.getSourceId(), source.getMinimumInterval(), source.getState().connected());
    }

    DXJobUpdate createJobUpdateEvent(DXEvent.Type type, Job job) {
        Job.State state = job.getState();
        return new DXJobUpdate(type, job.getJobId(), job.getMinimumInterval(), state.disabled(), state.pinned(), state.running());
    }

    DXItemUpdate createItemUpdateEvent(DXEvent.Type type, Item item) {
        return new DXItemUpdate(type, item.getItemId(), item.isPinned());
    }

    DXSourceType createSourceTypeObject(SourceType sourceType) {
        return new DXSourceType(sourceType.getDefaultMinimumInterval(), this.createJobTypeMap(sourceType));
    }

    Map<URI, DXJobType> createJobTypeMap(SourceType sourceType) {
        HashMap<URI, DXJobType> hashMap = new HashMap<URI, DXJobType>();
        for (JobType jobType : sourceType.jobTypeMap().values()) {
            hashMap.put(jobType.getJobTypeId(), this.createJobTypeObject(jobType));
        }
        return hashMap;
    }

    DXJobType createJobTypeObject(JobType jobType) {
        HashMap<URI, DXItemType> hashMap = new HashMap<URI, DXItemType>();
        for (ItemType itemType : jobType.itemTypeMap().values()) {
            hashMap.put(itemType.getItemTypeId(), this.createItemTypeObject(itemType));
        }
        return new DXJobType(jobType.getDefaultMinimumInterval(), jobType.isDefaultDisabled(), hashMap);
    }

    DXItemType createItemTypeObject(ItemType itemType) {
        return new DXItemType(itemType.getChangeClass());
    }

    DXSource createSourceObject(Source source) {
        HashMap<URI, DXJob> hashMap = new HashMap<URI, DXJob>();
        for (Job job : source.jobMap().values()) {
            hashMap.put(job.getJobId(), this.createJobObject(job));
        }
        return new DXSource(source.getConnectionDisplayName(), source.getMinimumInterval(), source.getState().connected(), hashMap);
    }

    DXJob createJobObject(Job job) {
        HashMap<URI, DXItem> hashMap = new HashMap<URI, DXItem>();
        for (Item item : job.itemMap().values()) {
            hashMap.put(item.getItemId(), this.createItemObject(item));
        }
        Job.State state = job.getState();
        return new DXJob(job.getMinimumInterval(), state.disabled(), state.pinned(), state.running(), hashMap);
    }

    DXItem createItemObject(Item item) {
        return new DXItem(item.isPinned());
    }
}

