/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.javafx.query;

import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.javafx.query.FxQuery;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.javatools.util.ModelUtil;

public abstract class FxQueryInfo<Q extends FxQuery, T> {
    private Q query;
    private T target;
    private String sql;
    private long updateInterval = 2500L;
    private boolean viewActive;
    protected String xmlFile;
    protected ClassLoader classLoader;
    protected String queryId;
    private boolean pauseWhenViewDeactivated;

    FxQueryInfo(String string, long l, T t) {
        this.sql = string;
        this.updateInterval = l;
        this.target = t;
    }

    public void setFqConnectionName(String string) {
        if (this.query != null) {
            ((FxQuery)this.query).setUpdateInterval(0L);
            ((FxQuery)this.query).unbind(this.target);
            this.query = null;
        }
        if (ModelUtil.hasLength((String)string)) {
            this.query = this.createFxQuery(string, this.getSql(string));
            this.initFxQuery(this.query);
            ((FxQuery)this.query).bind(this.target);
            ((FxQuery)this.query).setUpdateInterval(this.updateInterval);
            ((FxQuery)this.query).setPauseWhenViewDeactivated(this.pauseWhenViewDeactivated);
            ((FxQuery)this.query).setViewActive(this.viewActive);
        }
    }

    protected void initFxQuery(Q q) {
    }

    protected abstract Q createFxQuery(String var1, String var2);

    public void setUpdateInterval(long l) {
        this.updateInterval = l;
        if (this.query != null) {
            ((FxQuery)this.query).setUpdateInterval(l);
        }
    }

    public void setViewActive(boolean bl) {
        this.viewActive = bl;
        if (this.query != null) {
            ((FxQuery)this.query).setViewActive(bl);
        }
    }

    public void update() {
        if (this.query != null) {
            ((FxQuery)this.query).update();
        }
    }

    public FxQueryInfo<? extends FxQuery, T> xmlFile(String string) {
        this.xmlFile = string;
        return this;
    }

    public FxQueryInfo<? extends FxQuery, T> classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public FxQueryInfo<? extends FxQuery, T> queryId(String string) {
        this.queryId = string;
        return this;
    }

    public FxQueryInfo<? extends FxQuery, T> pauseWhenViewDeactivated(boolean bl) {
        this.pauseWhenViewDeactivated = bl;
        return this;
    }

    protected String getSql(String string) {
        if (!ModelUtil.hasLength((String)this.sql)) {
            assert (this.classLoader != null);
            assert (ModelUtil.hasLength((String)this.xmlFile));
            assert (ModelUtil.hasLength((String)this.queryId));
            assert (ModelUtil.hasLength((String)string));
            this.sql = this.getQuery(this.xmlFile, this.classLoader, this.queryId, string);
        }
        return this.sql;
    }

    private String getQuery(String string, ClassLoader classLoader, String string2, String string3) {
        String string4 = "";
        MetaResource metaResource = new MetaResource(classLoader, string);
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)metaResource);
        Query query = queryXMLSupport.getQuery(string2, string3);
        if (query != null) {
            string4 = query.getSql();
        }
        return string4;
    }
}

