/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractReconciler;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;

public class ExtractObject {
    public static String COPY_DDL = "COPY";
    public static String SCRIPT_DDL = "SCRIPT";
    public static final int TYPE_DBO = 0;
    public static final int TYPE_QUERY = 1;
    public static final int TYPE_PRESCRIPT = 2;
    public static final int TYPE_POSTSCRIPT = 3;
    private boolean _isExtractMeta = false;
    private boolean _isExtractData = false;
    private boolean _isPreSelected = false;
    private boolean _isSelectedMeta = false;
    private boolean _isSelectedData = false;
    private boolean _isSelectedFile = false;
    private boolean _isDataObject = false;
    private boolean _isDataPrepared = false;
    private boolean _isExistsSource = false;
    private boolean _isExistsDest = false;
    private ExtractListModel _listModel;
    private int _type = 0;
    private DBObject _dbo;
    private URL _url;
    private String _sourceConnName = "";
    private String _destConnName = "";
    private String _sourceConnUser = "";
    private String _destConnUser = "";
    private boolean _isSourceConnOracle;
    private boolean _isSourceConnTimesTen;
    private String _columns;
    private boolean _isLobsEmptySelect;
    private boolean _isNoLobsEmptySelect;
    private boolean _isLobsExcludedColumns;
    private boolean _isNoLobsExcludedColumns;
    private String _objectWhere = "";
    private JTable _table;
    private String _tableName;
    private List<?> _bindList;
    private Map<String, ?> _bindMap;
    private String _rawSql;
    private String _sql;
    private String _sqlLobs;
    private String _sqlNoLobs;
    private boolean _isVertical = false;
    private boolean _isSqlExtendable = true;
    private HashMap<Integer, ExtractScript> _scriptList;
    private HashMap<String, Object> _extendedProperties = new HashMap();
    private ArrayList<String> _destConstraints;
    private DDLGenerator _gen = DDLGenerator.getInstance();

    public ExtractObject(URL uRL, ExtractListModel extractListModel) {
        this.init(extractListModel);
        this._url = uRL;
        if (uRL != null) {
            this._dbo = new DBObject(uRL);
            this._sourceConnName = this._dbo.getConnectionName();
        }
    }

    public ExtractObject(DBObject dBObject, ExtractListModel extractListModel) {
        this.init(extractListModel);
        this._dbo = dBObject;
        this._sourceConnName = this._dbo.getConnectionName();
        this._url = this._dbo.getURL();
    }

    public ExtractObject(JTable jTable, ExtractListModel extractListModel) {
        this.init(extractListModel);
        this._table = jTable;
        this._tableName = this.getInternalTableName();
        this._type = 1;
    }

    public ExtractObject(int n, ExtractListModel extractListModel) {
        this.init(extractListModel);
        this._type = n;
    }

    private ExtractObject() {
    }

    public void setListModel(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        if (extractListModel != null) {
            this._gen.setFormating(this._listModel.getDDLFormat());
        }
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public boolean isTypeScript() {
        return this._type == 2 || this._type == 3;
    }

    public boolean isExistsSource() {
        return this._type == 0 ? this._isExistsSource : true;
    }

    public void isExistsSource(boolean bl) {
        this._isExistsSource = bl;
        if (bl) {
            this.setSourceConnName(this._sourceConnName);
        } else {
            this._isDataPrepared = false;
        }
    }

    public boolean isExistsDest() {
        return this._isExistsDest;
    }

    public void isExistsDest(boolean bl) {
        this._isExistsDest = bl;
    }

    public String getDDL(int n) {
        return this.getDDL(n, SCRIPT_DDL);
    }

    public String getDDL(int n, String string) {
        switch (n) {
            case 0: {
                return this.getDDLCreate(string);
            }
            case 1: {
                return this.getDDLCreate(string);
            }
            case 2: {
                return this.getDDLCreate(string);
            }
            case 3: {
                return this.getDDLCreate(string);
            }
            case 4: {
                return this.getDDLDrop();
            }
            case 5: {
                return this.getDDLTruncate();
            }
            case 7: {
                return this.getDDLDisableConstraints();
            }
            case 6: {
                return this.getDDLEnableConstraints();
            }
        }
        return new String("");
    }

    public HashMap<Integer, ExtractScript> getScripts() {
        if (this._scriptList == null) {
            this._scriptList = new HashMap();
        }
        return this._scriptList;
    }

    public boolean isIncludeScripts() {
        return this._scriptList != null && !this._scriptList.isEmpty();
    }

    public void addScript(String string, String string2, int n, boolean bl) {
        this.getScripts().put(n, new ExtractScript(string, string2, n, bl));
    }

    public void addScript(String string, String string2, String string3, boolean bl) {
        this.getScripts().put(ExtractScript.getExecuteWhen(string3), new ExtractScript(string, string2, ExtractScript.getExecuteWhen(string3), bl));
    }

    public void addScript(ExtractScript extractScript) {
        this.getScripts().put(extractScript.getExecuteWhen(), extractScript);
    }

    public ExtractScript getScript(int n) {
        return this.getScripts().get(n);
    }

    public boolean isScriptError() {
        boolean bl = false;
        ExtractScript extractScript = this.getScripts().get(110);
        if (this._isExtractMeta && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        extractScript = this.getScripts().get(111);
        if (this._isExtractMeta && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        extractScript = this.getScripts().get(112);
        if (this._isExtractData && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        extractScript = this.getScripts().get(113);
        if (this._isExtractData && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        extractScript = this.getScripts().get(114);
        if (this._type == 2 && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        extractScript = this.getScripts().get(115);
        if (this._type == 3 && extractScript != null && extractScript.isSelectedFile() && !new File(extractScript.getPath()).isFile()) {
            bl = true;
        }
        return bl;
    }

    public String getScriptTip() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        ExtractScript extractScript = this.getScripts().get(110);
        String string = "<html>";
        String string2 = " " + ExtractResources.getString("ERROR");
        Object[] objectArray = new Object[]{new String("")};
        if (this._isExtractMeta && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("BEFORE_CREATE")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        extractScript = this.getScripts().get(111);
        if (this._isExtractMeta && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("AFTER_CREATE")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        extractScript = this.getScripts().get(112);
        if (this._isExtractData && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("BEFORE_LOAD")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        extractScript = this.getScripts().get(113);
        if (this._isExtractData && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("AFTER_LOAD")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        extractScript = this.getScripts().get(114);
        if (this._type == 2 && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("INITIAL")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        extractScript = this.getScripts().get(115);
        if (this._type == 3 && extractScript != null && extractScript.isSelectedFile()) {
            bl = new File(extractScript.getPath()).isFile();
            stringBuffer.append(string + StringUtils.stripMnemonic((String)ExtractResources.getString("FINAL")) + (bl ? "" : string2) + ": " + extractScript.getPath());
            string = "<br>";
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString().trim();
    }

    public int[][] getScriptErrorRanges() {
        Vector vector = new Vector();
        int[][] nArray = new int[vector.size()][2];
        return nArray;
    }

    public void clearScripts() {
        this.getScripts().clear();
    }

    public void dropScript(int n) {
        this.getScripts().remove(n);
    }

    public Object getPropertyValue(String string) {
        return this._extendedProperties.get(string);
    }

    public void setProperty(String string, Object object) {
        this._extendedProperties.put(string, object);
    }

    public Set<String> getPropertyKeySet() {
        return this._extendedProperties.keySet();
    }

    public void isExtractMetaData(boolean bl) {
        this._isExtractMeta = bl;
    }

    public boolean isExtractMetaData() {
        return this._isExtractMeta;
    }

    public void isExtractData(boolean bl) {
        this._isExtractData = bl;
    }

    public boolean isExtractData() {
        return this._isExtractData;
    }

    public void isPreSelected(boolean bl) {
        this._isPreSelected = bl;
    }

    public boolean isPreSelected() {
        return this._isPreSelected;
    }

    public void isSelectedMetaData(boolean bl) {
        this._isSelectedMeta = bl;
    }

    public boolean isSelectedMetaData() {
        return this._isSelectedMeta;
    }

    public void isSelectedData(boolean bl) {
        this._isSelectedData = bl;
    }

    public boolean isSelectedData() {
        return this._isSelectedData;
    }

    public void isSelectedFile(boolean bl) {
        this._isSelectedFile = bl;
    }

    public boolean isSelectedFile() {
        return this._isSelectedFile;
    }

    public void isDataObject(boolean bl) {
        this._isDataObject = bl;
    }

    public boolean isDataObject() {
        return this._isDataObject;
    }

    public void isDataPrepared(boolean bl) {
        this._isDataPrepared = bl;
    }

    public boolean isDataPrepared() {
        return this._isDataPrepared;
    }

    public URL getUrl() {
        return this._url;
    }

    public void setUrl(URL uRL) {
        this._url = uRL;
    }

    public String getSourceConnName() {
        return this._sourceConnName;
    }

    private String getConnectionUser(Connection connection) {
        return this._listModel.getConnectionUser(connection);
    }

    public void setSourceConnName(String string) {
        this._sourceConnName = string;
        if (this._sourceConnName != null & this._sourceConnName.length() > 0) {
            this._isSourceConnOracle = Connections.getInstance().isOracle(this._sourceConnName);
            this._isSourceConnTimesTen = Connections.getInstance().isTimesTen(this._sourceConnName);
        }
    }

    public void setSourceConnUserName() {
        if (this._sourceConnName != null & this._sourceConnName.length() > 0 && this.getSourceConn() != null) {
            try {
                this._sourceConnUser = this.getConnectionUser(Connections.getInstance().getConnection(this._sourceConnName));
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
    }

    public void mapSourceConnection(String string) {
        String string2 = string;
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, this._dbo.getSchemaName(), this._dbo.getObjectType());
        URL uRL2 = DBURLFormatHelper.getURL(uRL, this._dbo.getObjectName());
        this._dbo = new DBObject(uRL2);
        this.setSourceConnName(string);
        this.setSourceConnUserName();
        this._listModel.getReconciler();
        this.isExistsSource(ExtractReconciler.reconcileExistence(this));
        this._isDataPrepared = false;
    }

    public Connection getSourceConn() {
        try {
            return Connections.getInstance().getConnection(this._sourceConnName);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public String getSourceConnUser(boolean bl) {
        if (this._sourceConnUser.length() == 0) {
            this.setSourceConnUserName();
        }
        return bl ? "\"" + this._sourceConnUser + "\"" : this._sourceConnUser;
    }

    public String getDestConnName() {
        return this._destConnName;
    }

    public void setDestConnName(String string) {
        this._destConnName = string;
    }

    public void setDestConnUserName() {
        if (this._destConnName != null & this._destConnName.length() > 0) {
            try {
                this._destConnUser = this.getConnectionUser(Connections.getInstance().getConnection(this._destConnName));
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
    }

    public Connection getDestConn() {
        try {
            return Connections.getInstance().getConnection(this._destConnName);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            return null;
        }
    }

    public String getDestConnUser(boolean bl) {
        if (this._destConnUser.length() == 0) {
            this.setDestConnUserName();
        }
        return bl ? "\"" + this._destConnUser + "\"" : this._destConnUser;
    }

    public boolean isOtherUser() {
        return !this._listModel.getSourceConnUser().equals(this._dbo.getSchemaName());
    }

    public ExtractListModel getListModel() {
        return this._listModel;
    }

    private void dataPrepare() {
        block7: {
            try {
                if (Connections.getInstance().getConnection(this._sourceConnName) == null) {
                    return;
                }
                this._isDataPrepared = true;
                if (this._type == 0) {
                    this.initSqlForDBO();
                    this.scrubColList(null);
                    this._columns = "*";
                    if (this._table != null || !this._isSourceConnTimesTen) break block7;
                    ResultSetTable resultSetTable = new ResultSetTable();
                    resultSetTable.setQuery(this.getDBObject().getConnectionName(), this.getSqlForVisibleCols(), this.getBindList(), this.getBindMap());
                    try {
                        resultSetTable.open(false);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    this._table = resultSetTable;
                    break block7;
                }
                if (this._listModel.isTypeQuery()) {
                    this.initSqlForQuery();
                    this.scrubColList(this._table);
                    this.finalizeSqlForQuery();
                    this._columns = "*";
                    this._objectWhere = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getColumns() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._columns;
    }

    public void setColumns(String string) {
        this._columns = string;
    }

    public String getWhereString() {
        return this._objectWhere;
    }

    public String getWhere() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._objectWhere;
    }

    public void setWhere(String string) {
        int n = string.trim().toLowerCase().indexOf("where");
        this._objectWhere = n != 0 ? string : string.substring(n + 6);
    }

    public String getSql() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._sql;
    }

    public String getFinalSQL() {
        String string = this.getFinalWhere();
        return string.length() > 0 ? this.getSql() + " " + this.getFinalWhere() : this.getSql();
    }

    public String getFinalWhere() {
        String string = this._objectWhere;
        if (this._listModel.getGlobalWhere().length() != 0) {
            if (string.length() != 0) {
                string = string + " and ";
            }
            string = string + this._listModel.getGlobalWhere();
        }
        return string.length() > 0 ? " where " + string : string;
    }

    public void setSql(String string) {
        this._sql = string;
    }

    public String getRawSql() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._rawSql;
    }

    public void setRawSql(String string) {
        this._rawSql = string;
    }

    public boolean isEmptySelect() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._listModel.isAllowLobs() ? this._isLobsEmptySelect : this._isNoLobsEmptySelect;
    }

    public boolean isExcludedColumns() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._columns != "*" ? true : (this._listModel.isAllowLobs() ? this._isLobsExcludedColumns : this._isNoLobsExcludedColumns);
    }

    public boolean isSqlExtendable() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._isSqlExtendable;
    }

    public String getSqlForVisibleCols() {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        return this._columns != "*" ? "select " + this._columns + this.calculateFrom(this._sql) : this._sql;
    }

    public List<?> getBindList() {
        return this._bindList;
    }

    public void setBindList(List<?> list) {
        this._bindList = list;
    }

    public Map<String, ?> getBindMap() {
        return this._bindMap;
    }

    public void setBindMap(Map<String, ?> map) {
        this._bindMap = map;
    }

    public JTable getTable() {
        return this._table;
    }

    public void setTable(JTable jTable) {
        this._table = jTable;
    }

    public boolean isTableDirty() {
        if (this._table != null && this._table.getModel() != null && this._table.getModel() instanceof ResultSetTableModel) {
            if (((ResultSetTableModel)((Object)this._table.getModel())).getSql() != null) {
                if (this.getFinalWhere().length() == 0) {
                    return false;
                }
                return !((ResultSetTableModel)((Object)this._table.getModel())).getSql().equals(this.getFinalSQL());
            }
            return true;
        }
        return false;
    }

    public String getTableName() {
        if (this._dbo != null) {
            if (this._listModel.getDDLFormat() != null && this._listModel.getDDLFormat().getSchema()) {
                return DBUtil.addDoubleQuote((String)this._dbo.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
            }
            return DBUtil.addDoubleQuote((String)this._dbo.getObjectName());
        }
        return this._tableName;
    }

    public void setTableName(String string) {
        this._tableName = string;
    }

    public boolean isInList(List<ExtractObject> list) {
        for (ExtractObject extractObject : list) {
            if (!this.equals(extractObject)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(ExtractObject extractObject) {
        return this._type == extractObject._type && this._url.equals(extractObject._url);
    }

    public DBObject getDBObject() {
        return this._dbo;
    }

    public JLabel getLabel() {
        JLabel jLabel = new JLabel();
        if (this._dbo != null) {
            jLabel.setText(this._dbo.getObjectName());
            jLabel.setIcon(DBURLFormatHelper.getIcon(this._dbo.getURL()));
        } else if (this._table != null && this._tableName != null) {
            jLabel.setText(this._tableName);
        }
        return jLabel;
    }

    public String calculateFrom(String string) {
        if (!this._isDataPrepared) {
            this.dataPrepare();
        }
        if (this._isSourceConnOracle || this._isSourceConnTimesTen) {
            return " from (" + string + ")";
        }
        return " from (" + string + ") as t";
    }

    private void initSqlForDBO() {
        this.setBindMap(this.getDBObject().getDictionary());
        String string = DBUtil.getInstance((String)this._sourceConnName).addDbQuotes(this.getDBObject().getObjectName());
        this._sql = this._isSourceConnOracle || this._isSourceConnTimesTen ? "select * from (select * from " + this.getSchema() + "." + string + ")" : (this.getSchema() != null ? "select * from (select * from " + this.getSchema() + "." + string + ") as t" : "select * from (select * from " + DBUtil.addDoubleQuote((String)this.getDBObject().getObjectName()) + ") as t");
        this._rawSql = this._sql;
        if (this._isSourceConnTimesTen) {
            this._isSqlExtendable = false;
        }
    }

    private String getSchema() {
        return this.getDBObject().getSchemaName() == null || this.getDBObject().getSchemaName().equals("") ? null : DBUtil.getInstance((String)this._sourceConnName).addDbQuotes(this.getDBObject().getSchemaName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubColList(JTable jTable) {
        if (this._isSourceConnOracle && !this._isSourceConnTimesTen) {
            try {
                Object object;
                TabCol tabCol = new TabCol(this._sourceConnName);
                if (jTable != null && jTable.getModel() instanceof IResultSetTableModel) {
                    tabCol.resultSet = object = (IResultSetTableModel)((Object)jTable.getModel());
                }
                object = tabCol.fetchColumns(this._sql, false);
                tabCol.colTypesToExclude = new ArrayList<String>();
                tabCol.colNamesToExclude = new ArrayList<String>();
                tabCol.colNamesToExclude.add("ORA_ROWSCN");
                tabCol.colNamesToExclude.add("ROWID");
                tabCol.colTypesToExclude = new ArrayList<String>();
                this._sqlLobs = tabCol.disambiguate((ArrayList<TabCol.Column>)object);
                this._isLobsEmptySelect = tabCol.isEmptySelect();
                this._isLobsExcludedColumns = tabCol.excludedColumns();
                tabCol.colTypesToExclude.add("BLOB");
                tabCol.colTypesToExclude.add("CLOB");
                tabCol.colTypesToExclude.add("NCLOB");
                this._sqlNoLobs = tabCol.disambiguate((ArrayList<TabCol.Column>)object);
                this._isNoLobsEmptySelect = tabCol.isEmptySelect();
                this._isNoLobsExcludedColumns = tabCol.excludedColumns();
                if (tabCol.isEmptySelect()) {
                    this._sqlNoLobs = !tabCol.excludedColumns() ? this._rawSql : "";
                }
                this._sql = this._listModel.isAllowLobs() ? this._sqlLobs : this._sqlNoLobs;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return;
        }
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl2 = false;
        try {
            bl2 = Connections.getInstance().lock(this._sourceConnName);
            DBUtil dBUtil = DBUtil.getInstance((String)this._sourceConnName);
            if (jTable != null && jTable.getModel() instanceof IResultSetTableModel) {
            } else {
                bl = true;
                if (this._bindMap != null && !this._bindMap.isEmpty()) {
                    this._sql = dBUtil.prepareNonOracleSql(this._sql, this._bindMap).getSQL();
                    statement = Connections.getInstance().getConnection(this._sourceConnName).prepareStatement(this._sql);
                } else if (this._bindList != null && !this._bindList.isEmpty()) {
                    this._sql = dBUtil.prepareNonOracleSql(this._sql);
                    statement = Connections.getInstance().getConnection(this._sourceConnName).prepareStatement(this._sql);
                    DBUtil.bind((PreparedStatement)statement, this._bindList);
                }
                resultSet = statement.executeQuery();
                this._sqlLobs = this._sql;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (resultSetMetaData != null) {
                    int n;
                    int n2 = 0;
                    String string = null;
                    int n3 = resultSetMetaData.getColumnCount();
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = "";
                    for (n = 0; n < n3; ++n) {
                        n2 = resultSetMetaData.getColumnType(n + 1);
                        string = resultSetMetaData.getColumnName(n + 1);
                        if (n2 != 2004 && n2 != 2005 && n2 != 2011) {
                            stringBuffer.append(string2 + "\"" + string + "\"");
                            string2 = ",";
                            continue;
                        }
                        this._isNoLobsExcludedColumns = true;
                    }
                    if (stringBuffer.length() == 0) {
                        this._isNoLobsEmptySelect = true;
                    }
                    if (this._isNoLobsExcludedColumns) {
                        n = this._sql.indexOf("(");
                        this._sqlNoLobs = "SELECT " + stringBuffer.toString() + " from " + this._sql.substring(n);
                    } else {
                        this._sqlNoLobs = this._sql;
                    }
                    this._sql = this._listModel.isAllowLobs() ? this._sqlLobs : this._sqlNoLobs;
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (bl2) {
                Connections.getInstance().unlock(this._sourceConnName);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (bl && resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void initSqlForQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._table.getModel() instanceof IResultSetTableModel) {
            try {
                this._isVertical = ((IResultSetTableModel)((Object)this._table.getModel())).isVerticalDisplay();
                this._sql = ((IResultSetTableModel)((Object)this._table.getModel())).getModifiedSql();
                int n = 0;
                n = !this._isVertical ? this._table.getColumnCount() : ((IResultSetTableModel)((Object)this._table.getModel())).getResultSetMetaData().getColumnCount();
                boolean bl = false;
                String string = null;
                for (int i = 0; i < n; ++i) {
                    string = !this._isVertical ? this._table.getColumnName(i) : ((IResultSetTableModel)((Object)this._table.getModel())).getResultSetMetaData().getColumnName(i + 1);
                    if (!("ORA_ROWSCN".equals(string) || "ROWID".equals(string) || "SDEV_LINK_OWNER".equals(string) || "SDEV_LINK_NAME".equals(string) || "SDEV_LINK_TYPE".equals(string) || "SDEV_LINK_LINE".equals(string))) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        if (string.equals("TABLESPACE NAME") && (this._sql.contains("tablespace_name") || this._sql.contains("TABLESPACE_NAME"))) {
                            string = "TABLESPACE_NAME";
                        } else if (string.equals("PCT USED") && (this._sql.contains("pct_used") || this._sql.contains("PCT_USED"))) {
                            string = "PCT_USED";
                        } else if (string.equals("PERCENT USED") && (this._sql.contains("percent_used") || this._sql.contains("PERCENT USED"))) {
                            string = "PERCENT_USED";
                        }
                        stringBuilder.append(DBUtil.addDoubleQuote((String)string));
                    }
                    if (!"LEVEL".equals(string) || !this._sql.contains("CONNECT BY") && !this._sql.contains("connect by")) continue;
                    bl = true;
                }
                if (!bl) {
                    this._sql = "SELECT " + stringBuilder + " FROM (" + this._sql + ")";
                }
                this._rawSql = this._sql;
                this._bindMap = ((IResultSetTableModel)((Object)this._table.getModel())).getBindMap();
                this._bindList = ((IResultSetTableModel)((Object)this._table.getModel())).getBindList();
                this._isSqlExtendable = !this._sql.trim().toLowerCase().startsWith("--notextendable");
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return;
            }
        }
    }

    private void finalizeSqlForQuery() {
        if (!this._isSqlExtendable) {
            this._sql = "\n" + this._sql + "\n";
            if (this._sqlLobs != null) {
                this._sqlLobs = "\n" + this._sqlLobs + "\n";
            }
            if (this._sqlNoLobs != null) {
                this._sqlLobs = "\n" + this._sqlLobs + "\n";
            }
        } else if (this._isSourceConnOracle || this._isSourceConnTimesTen) {
            this._sql = "select * from (\n" + this._sql + "\n)";
            if (this._sqlLobs != null) {
                this._sqlLobs = "select * from (\n" + this._sqlLobs + "\n)";
            }
            if (this._sqlNoLobs != null) {
                this._sqlNoLobs = "select * from (\n" + this._sqlNoLobs + "\n)";
            }
        } else {
            this._sql = "select * from (\n" + this._sql + "\n) as t";
            if (this._sqlLobs != null) {
                this._sqlLobs = "select * from (\n" + this._sqlLobs + "\n) as t";
            }
            if (this._sqlNoLobs != null) {
                this._sqlNoLobs = "select * from (\n" + this._sqlNoLobs + "\n) as t";
            }
        }
    }

    private String getInternalTableName() {
        String string = "";
        if (this._table instanceof ResultSetTable) {
            string = ((ResultSetTable)((Object)this._table)).getDefaultExportName();
        }
        if (string == null || string.length() == 0) {
            string = ExtractResources.getString("EO_DEFAULT_EXPORT_NAME");
        }
        return string;
    }

    private String getDDLCreate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.setListModel(this._listModel);
        try {
            if (string.equals(COPY_DDL)) {
                this.addSql(stringBuilder, "set define off;" + this.getTerm(), false);
                boolean bl = this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE");
                String string2 = this._gen.getCopyDDL(this._dbo);
                this.addSql(stringBuilder, string2, bl);
            } else if (this._dbo.getObjectType().equals("TABLE") && this._listModel.getDDLTypes().getTableDeps()) {
                this.addSql(stringBuilder, this._gen.getDDL(this._dbo, "DEP"), false);
                if (this._listModel.getDDLFormat().getGrant()) {
                    this.addSql(stringBuilder, this._gen.getGrants(this._dbo), false);
                }
            } else {
                boolean bl = this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE");
                String string3 = this._gen.getScriptDDL(this._dbo);
                string3 = string3.trim();
                if (this._listModel.getDDLFormat().getTerminator()) {
                    if (string3 != null && string3.length() > 0 && string3.lastIndexOf("/") == string3.length() - 1) {
                        String string4 = string3.substring(0, string3.lastIndexOf("/"));
                        string3 = string4 + this.getTerm() + "/" + this.getTerm();
                    } else if (this._dbo.getObjectType().equals("QUEUE TABLE") || this._dbo.getObjectType().equals("QUEUE")) {
                        string3 = string3 + this.getTerm() + "/" + this.getTerm();
                    }
                }
                this.addSql(stringBuilder, string3, bl);
                if (this._listModel.getDDLFormat().getGrant()) {
                    this.addSql(stringBuilder, this._gen.getGrants(this._dbo), bl);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return stringBuilder.toString().trim();
    }

    private String getDDLDrop() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\"" + this._dbo.getObjectName() + "\"";
        if (this._listModel.getDDLFormat().getSchema()) {
            string = "\"" + this._dbo.getSchemaName() + "\"." + "\"" + this._dbo.getObjectName() + "\"";
        }
        if (this._dbo.getObjectType().equals("MATERIALIZED VIEW LOG")) {
            stringBuilder.append("  DROP " + this._dbo.getObjectType() + " on " + string + ";" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("TABLE") && this._listModel.getDDLFormat().getCascade()) {
            stringBuilder.append("  DROP " + this._dbo.getObjectType() + " " + string + " cascade constraints;" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("TABLE")) {
            stringBuilder.append("  DROP " + this._dbo.getObjectType() + " " + string + ";" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("QUEUE")) {
            stringBuilder.append("begin" + this.getTerm() + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + this._dbo.getObjectName() + "', auto_commit=>TRUE);" + this.getTerm() + "end;" + this.getTerm() + "/" + this.getTerm());
        } else if (this._dbo.getObjectType().equals("QUEUE TABLE")) {
            stringBuilder.append("begin" + this.getTerm() + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + this._dbo.getObjectName() + "', force=>TRUE);" + this.getTerm() + "end;" + this.getTerm() + "/" + this.getTerm());
        } else {
            stringBuilder.append("  DROP " + this._dbo.getObjectType() + " " + string + ";" + this.getTerm());
        }
        return stringBuilder.toString();
    }

    private String getDDLTruncate() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\"" + this._dbo.getObjectName() + "\"";
        if (this._listModel.getDDLFormat().getSchema()) {
            string = "\"" + this._dbo.getSchemaName() + "\"." + "\"" + this._dbo.getObjectName() + "\"";
        }
        if (this._dbo.getObjectType().equals("TABLE")) {
            stringBuilder.append("  TRUNCATE " + this._dbo.getObjectType() + " " + string + ";" + this.getTerm());
        }
        return stringBuilder.toString();
    }

    private String getDDLDisableConstraints() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.getConstraintSQL("DISABLE"));
        return stringBuilder.toString();
    }

    private String getDDLEnableConstraints() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.getConstraintSQL("ENABLE"));
        return stringBuilder.toString();
    }

    private StringBuilder getConstraintSQL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Connection connection = this._listModel.getDestConn();
        String string2 = "";
        if (connection != null) {
            string2 = this._listModel.getDestConnUser();
            if (this._destConstraints == null) {
                this._destConstraints = this.getObjectConstraints(connection);
            }
            String string3 = "\"" + this._dbo.getObjectName() + "\"";
            if (this._listModel.getDDLFormat().getSchema()) {
                string3 = "\"" + string2 + "\"." + "\"" + this._dbo.getObjectName() + "\"";
            }
            for (String string4 : this._destConstraints) {
                if (!this._dbo.getObjectType().equals("TABLE")) continue;
                stringBuilder.append("alter table " + string3 + " " + string + " constraint " + "\"" + string4 + "\"" + ";" + this.getTerm());
            }
            return stringBuilder;
        }
        String string5 = "";
        if (this._listModel.getDDLFormat().getSchema()) {
            string2 = this._dbo.getSchemaName();
            string5 = "begin" + this.getTerm() + "for cur in (select owner, constraint_name , table_name" + this.getTerm() + "from all_constraints" + this.getTerm() + "where owner = '" + string2 + "'" + this.getTerm() + "and constraint_type = 'R'" + this.getTerm() + "and TABLE_NAME = '" + this._dbo.getObjectName() + "' )" + this.getTerm() + "loop" + this.getTerm() + "execute immediate 'ALTER TABLE '||cur.owner||'.'||cur.table_name||' MODIFY CONSTRAINT \"'||cur.constraint_name||'\" " + string + " ';" + this.getTerm() + "end loop;" + this.getTerm() + "end;" + this.getTerm();
        } else {
            string5 = "begin" + this.getTerm() + "for cur in (select constraint_name , table_name" + this.getTerm() + "from user_constraints" + this.getTerm() + "where constraint_type = 'R'" + this.getTerm() + "and TABLE_NAME = '" + this._dbo.getObjectName() + "' )" + this.getTerm() + "loop" + this.getTerm() + "execute immediate 'ALTER TABLE '||cur.table_name||' MODIFY CONSTRAINT \"'||cur.constraint_name||'\" " + string + " ';" + this.getTerm() + "end loop;" + this.getTerm() + "end;" + this.getTerm();
        }
        stringBuilder.append(string5);
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<String> getObjectConstraints(Connection connection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("NAME", this._dbo.getObjectName());
        String string = "select constraint_name from user_constraints where constraint_type = 'R' and table_name =:NAME ";
        if (Connections.getInstance().lock(connection)) {
            try {
                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    private void addSql(StringBuilder stringBuilder, String string, boolean bl) {
        if (string.length() < 1) {
            return;
        }
        if (!this._listModel.getDDLFormat().getSchema()) {
            string = bl ? string.replaceAll("'" + this._dbo.getSchemaName() + ".", "'") : string.replace("\"" + this._dbo.getSchemaName() + "\".", "");
        }
        stringBuilder.append(string);
    }

    private String getTerm() {
        return "\n";
    }

    private void init(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
        if (extractListModel != null) {
            this._gen.setFormating(this._listModel.getDDLFormat());
            this.setSourceConnName(this._listModel.getSourceConnName());
            this.setDestConnName(this._listModel.getDestConnName());
        }
    }

    private void setDBObject(DBObject dBObject) {
        this._dbo = dBObject;
        this._url = this._dbo.getURL();
    }

    private void isLobsEmptySelect(boolean bl) {
        this._isLobsEmptySelect = bl;
    }

    private void isNoLobsEmptySelect(boolean bl) {
        this._isNoLobsEmptySelect = bl;
    }

    private void isLobsExcludedColumns(boolean bl) {
        this._isLobsExcludedColumns = bl;
    }

    private void isNoLobsExcludedColumns(boolean bl) {
        this._isNoLobsExcludedColumns = bl;
    }

    private void setSqlLobs(String string) {
        this._sqlLobs = string;
    }

    private void setSqlNoLobs(String string) {
        this._sqlNoLobs = string;
    }

    private void isVertical(boolean bl) {
        this._isVertical = bl;
    }

    private void isSqlExtendable(boolean bl) {
        this._isSqlExtendable = bl;
    }

    private void setExtendedProperties(HashMap<String, Object> hashMap) {
        this._extendedProperties = hashMap;
    }

    private void setDestConstraints(ArrayList<String> arrayList) {
        this._destConstraints = arrayList;
    }

    public ExtractObject clone() {
        ExtractObject extractObject = new ExtractObject();
        extractObject.isExtractMetaData(this._isExtractMeta);
        extractObject.isExtractData(this._isExtractData);
        extractObject.isPreSelected(this._isPreSelected);
        extractObject.isSelectedMetaData(this._isSelectedMeta);
        extractObject.isSelectedData(this._isSelectedData);
        extractObject.isDataObject(this._isDataObject);
        extractObject.isDataPrepared(this._isDataPrepared);
        extractObject.isExistsSource(this._isExistsSource);
        extractObject.isExistsDest(this._isExistsDest);
        extractObject.setListModel(this._listModel);
        extractObject.setType(this._type);
        extractObject.setDBObject(this._dbo);
        extractObject.setUrl(this._url);
        if (this._type == 0) {
            extractObject.setSourceConnName(this._sourceConnName);
            extractObject.setDestConnName(this._destConnName);
        }
        extractObject.setColumns(this._columns);
        extractObject.isLobsEmptySelect(this._isLobsEmptySelect);
        extractObject.isNoLobsEmptySelect(this._isNoLobsEmptySelect);
        extractObject.isLobsExcludedColumns(this._isLobsExcludedColumns);
        extractObject.isNoLobsExcludedColumns(this._isNoLobsExcludedColumns);
        extractObject.setWhere(this._objectWhere);
        extractObject.setTable(this._table);
        extractObject.setTableName(this._tableName);
        extractObject.setBindList(this._bindList);
        extractObject.setBindMap(this._bindMap);
        extractObject.setRawSql(this._rawSql);
        extractObject.setSql(this._sql);
        extractObject.setSqlLobs(this._sqlLobs);
        extractObject.setSqlNoLobs(this._sqlNoLobs);
        extractObject.isVertical(this._isVertical);
        extractObject.isSqlExtendable(this._isSqlExtendable);
        extractObject.setExtendedProperties(this._extendedProperties);
        extractObject.setDestConstraints(this._destConstraints);
        this.cloneScript(extractObject, 110);
        this.cloneScript(extractObject, 111);
        this.cloneScript(extractObject, 112);
        this.cloneScript(extractObject, 113);
        this.cloneScript(extractObject, 114);
        this.cloneScript(extractObject, 115);
        return extractObject;
    }

    private void cloneScript(ExtractObject extractObject, int n) {
        ExtractScript extractScript = this.getScript(n);
        if (extractScript != null) {
            extractObject.addScript(extractScript.clone());
        }
    }

    public void convertToDest() {
        this.isExistsSource(false);
        this.isExistsDest(true);
        this.setDestConnName(this._sourceConnName);
        this.setDestConnUserName();
        this.setSourceConnName("");
    }

    public String getIndent(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 9;
        }
        return new String(cArray);
    }

    public String toXML(int n) {
        return this.toXML(new StringBuffer(), n).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer, int n) {
        if (this._type == 0) {
            stringBuffer.append(this.getIndent(n) + "<dbobject");
            stringBuffer.append(">\n");
            stringBuffer.append(this.getIndent(n + 1) + "<objectconnection><![CDATA[" + this._sourceConnName + "]]></objectconnection>\n");
            stringBuffer.append(this.getIndent(n + 1) + "<objecttype><![CDATA[" + this._dbo.getObjectType() + "]]></objecttype>\n");
            stringBuffer.append(this.getIndent(n + 1) + "<objectschema><![CDATA[" + this._dbo.getSchemaName() + "]]></objectschema>\n");
            stringBuffer.append(this.getIndent(n + 1) + "<objectname><![CDATA[" + this._dbo.getObjectName() + "]]></objectname>\n");
            if (this._dbo.getObjectType().equals("APEX")) {
                stringBuffer.append(this.getIndent(n + 1) + "<applicationname><![CDATA[" + this._dbo.getDictionary().get("APPLICATION_NAME").toString() + "]]></applicationname>\n");
                stringBuffer.append(this.getIndent(n + 1) + "<workspacename><![CDATA[" + this._dbo.getDictionary().get("WORKSPACE").toString() + "]]></workspacename>\n");
            }
            if (this._isPreSelected) {
                stringBuffer.append(this.getIndent(n + 1) + "<include><![CDATA[" + "true" + "]]></include>\n");
            } else {
                stringBuffer.append(this.getIndent(n + 1) + "<include><![CDATA[" + "false" + "]]></include>\n");
            }
            if (this._isExtractMeta) {
                stringBuffer.append(this.getIndent(n + 1) + "<meta><![CDATA[" + "true" + "]]></meta>\n");
            } else {
                stringBuffer.append(this.getIndent(n + 1) + "<meta><![CDATA[" + "false" + "]]></meta>\n");
            }
            if (this._isExtractData) {
                stringBuffer.append(this.getIndent(n + 1) + "<data><![CDATA[" + "true" + "]]></data>\n");
            } else {
                stringBuffer.append(this.getIndent(n + 1) + "<data><![CDATA[" + "false" + "]]></data>\n");
            }
            if (this.getSql() != null && this.getSql().length() > 0) {
                stringBuffer.append(this.getIndent(n + 1) + "<filter><![CDATA[" + this.getWhere() + "]]></filter>\n");
            }
            if (this.isIncludeScripts()) {
                stringBuffer.append(this.getIndent(n + 1) + "<scripts");
                stringBuffer.append(">\n");
                Collection<ExtractScript> collection = this.getScripts().values();
                for (ExtractScript extractScript : collection) {
                    extractScript.toXML(stringBuffer, n + 2);
                }
                stringBuffer.append(this.getIndent(n + 1) + "</scripts>\n");
            }
            stringBuffer.append(this.getIndent(n) + "</dbobject>\n");
        } else if (this._type == 2 || this._type == 3) {
            stringBuffer.append(this.getIndent(n) + "<fileobject");
            stringBuffer.append(">\n");
            Integer n2 = this._type;
            stringBuffer.append(this.getIndent(n + 1) + "<filetype><![CDATA[" + n2.toString() + "]]></filetype>\n");
            stringBuffer.append(this.getIndent(n + 1) + "<fileurl><![CDATA[" + this.getUrl() + "]]></fileurl>\n");
            if (this.isPreSelected()) {
                stringBuffer.append(this.getIndent(n + 1) + "<includefile><![CDATA[" + "true" + "]]></includefile>\n");
            } else {
                stringBuffer.append(this.getIndent(n + 1) + "<includefile><![CDATA[" + "false" + "]]></includefile>\n");
            }
            if (this.isIncludeScripts()) {
                stringBuffer.append(this.getIndent(n + 1) + "<scripts");
                stringBuffer.append(">\n");
                Collection<ExtractScript> collection = this.getScripts().values();
                for (ExtractScript extractScript : collection) {
                    extractScript.toXML(stringBuffer, n + 2);
                }
                stringBuffer.append(this.getIndent(n + 1) + "</scripts>\n");
            }
            stringBuffer.append(this.getIndent(n) + "</fileobject>\n");
        }
        return stringBuffer;
    }
}

