/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.BindConfig;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class BindDialog {
    public static Map<String, Object> getBindValues(final String string) {
        final Object[] objectArray = new Object[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List list = DBUtil.getBinds((String)string);
                HashMap hashMap = Collections.emptyMap();
                if (list.size() > 0) {
                    Map map = BindDialog.getOldBindEntries(list);
                    Query query = BindDialog.showBindDialog(map);
                    if (query == null) {
                        objectArray[0] = null;
                        return;
                    }
                    hashMap = query.getBindValues();
                    BindConfig bindConfig = BindConfig.getInstance();
                    for (String string2 : hashMap.keySet()) {
                        Object v = hashMap.get(string2);
                        if (v != null && !DBUtil.NULL_VALUE.equals(v)) {
                            bindConfig.setString(string2, v.toString());
                            continue;
                        }
                        bindConfig.setString(string2, null);
                    }
                }
                objectArray[0] = hashMap;
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("BindDialog").log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
            objectArray[0] = null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger("BindDialog").log(Level.WARNING, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
            objectArray[0] = null;
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        return (Map)objectArray[0];
    }

    private static Query showBindDialog(Map<String, Bind> map) {
        Bind bind2;
        boolean[] blArray = new boolean[]{false};
        Query query = new Query();
        for (Bind bind2 : map.values()) {
            query.addBind(bind2);
        }
        BindInfo bindInfo = new BindInfo(query);
        HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
        bind2 = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)Messages.getString("BasicObjectModifier.1"), (int)14);
        bind2.setDefaultButton(8);
        ActionListener actionListener = new ActionListener((JEWTDialog)bind2, blArray){
            final /* synthetic */ JEWTDialog val$dlg;
            final /* synthetic */ boolean[] val$doBindApply;
            {
                this.val$dlg = jEWTDialog;
                this.val$doBindApply = blArray;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dlg.setVisible(false);
                this.val$doBindApply[0] = true;
                this.val$dlg.dispose();
            }
        };
        bind2.addActionListener(actionListener);
        bind2.setSize(600, 300);
        bind2.setPreferredSize(bindInfo.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)bind2);
        bind2.setVisible(true);
        return blArray[0] ? query : null;
    }

    private static Map<String, Bind> getOldBindEntries(List<String> list) {
        HashMap<String, Bind> hashMap = new HashMap<String, Bind>();
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = list.get(i);
            if (string2.startsWith(":") && string2.length() > 1) {
                string2 = string2.substring(1);
            }
            if ((string = BindConfig.getInstance().getString(string2)) == null) {
                string = "NULL_VALUE";
            }
            Bind bind = new Bind(string2, string2, string2, string, string2);
            if (hashMap.get(string2) != null) continue;
            hashMap.put(string2, bind);
        }
        return hashMap;
    }
}

