/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class OracleTempTabGroupDDL
extends OracleObjectDDL {
    @Override
    protected String getDDLHeader(DBObject dBObject) {
        return this.getHeader("Temporary Tablespace Group", dBObject.getObjectName());
    }

    @Override
    protected String getQueryFile() {
        return "";
    }

    @Override
    protected String getQueryKey(String string) {
        return "";
    }

    @Override
    protected String doGetDDLScript(DBObject dBObject) {
        return this.doGetDDL(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doGetDDL(DBObject dBObject) {
        String string = "select 'ALTER TABLESPACE '||tablespace_name||' TABLESPACE GROUP '||:OBJECT_NAME||';\n' as SQLSTRING from dba_tablespace_groups where group_name = :OBJECT_NAME  union all  select 'ALTER DATABASE DEFAULT TEMPORARY TABLESPACE '||property_value||';\n' as sql_string  from database_properties   where property_name = 'DEFAULT_TEMP_TABLESPACE'  and property_value = :OBJECT_NAME ";
        StringBuilder stringBuilder = new StringBuilder();
        Connection connection = dBObject.getConnection();
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    hashMap.put("OBJECT_NAME", dBObject.getObjectName());
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return stringBuilder.toString();
    }
}

