/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.validators.DateValidator;

public class ColumnDefinitionDetective {
    private static Pattern _uriPattern = Pattern.compile("^[a-z0-9-\\.\\+]{2,10}:$");
    private Locale _locale;
    private NumberFormat _fmt;
    private DateValidator _dateValidator = new DateValidator();
    private static final String[] DATE_MASKS = new String[]{"DD-MON-RR", "RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD"};
    private static final String[] TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF"};
    String _temporalType;
    int _formatIndex;
    String _format;

    public ColumnDefinitionDetective() {
        this(null);
    }

    public ColumnDefinitionDetective(Locale locale) {
        this._locale = locale;
        if (this._locale != null) {
            this._fmt = NumberFormat.getInstance(this._locale);
            this._dateValidator.setLocale(this._locale);
        } else {
            this._fmt = NumberFormat.getInstance();
        }
    }

    public void detect(List<Object[]> list, LoadField loadField, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        Column column = loadField.getColumn();
        int n = loadField.getColumn().getSourceColID();
        Column column2 = new Column();
        int n2 = column.getPrecision();
        int n3 = 0;
        boolean bl4 = column.getPrecision() != 0;
        boolean bl5 = bl;
        this.temporalInit();
        Iterator<Object[]> iterator = list.iterator();
        column.setPrecision(0);
        while (iterator.hasNext() && (bl2 || bl3 || !bl4)) {
            column2.setPrecision(0);
            column2.setScale(0);
            column2.setFormat("");
            if (bl5) {
                iterator.next();
                bl5 = false;
            } else {
                Object[] objectArray = iterator.next();
                String string = null;
                if (n < objectArray.length && objectArray[n] != null) {
                    string = objectArray[n].toString();
                }
                if (string != null && string.length() > 0) {
                    if (bl2 && this.isNumber(string, column2, true)) {
                        if (column2.getPrecision() - column2.getScale() > column.getPrecision() - column.getScale() && n3 < column2.getPrecision() - column2.getScale()) {
                            n3 = column2.getPrecision() - column2.getScale();
                        }
                        if (column.getScale() < column2.getScale()) {
                            column.setScale(column2.getScale());
                        }
                    } else {
                        bl2 = false;
                        if (column.getPrecision() < string.length()) {
                            column.setPrecision(string.length());
                        }
                    }
                    if (bl2 || !bl3 || !this.isTemporal(string, column2)) {
                        bl3 = false;
                    }
                }
            }
            if (bl2 || bl3 || !bl4) continue;
            column.setPrecision(n2);
        }
        if (bl2) {
            column.setPrecision(n3 + column.getScale());
            if (column.getPrecision() == 0 && column.getScale() == 0) {
                bl2 = false;
            }
        }
        if (bl2) {
            column.setType(DataType.NUMBER.toString());
        } else if (bl3 && column2.getType() != null) {
            column.setType(column2.getType());
            column.setFormat(column2.getFormat());
        } else {
            column.setType(DataType.VARCHAR2.toString());
            column.setScale(0);
            if (bl4) {
                column.setPrecision(n2);
            }
        }
        loadField.setDetectedType(column.getType());
        loadField.setDetectedPrecision(column.getPrecision());
        loadField.setDetectedScale(column.getScale());
    }

    public void detectFormat(List<Object[]> list, Column column, boolean bl) {
        String[] stringArray;
        boolean bl2 = bl;
        this.temporalInit();
        int n = column.getSourceColID();
        Iterator<Object[]> iterator = list.iterator();
        if (column.getType().equals(DataType.DATE.toString())) {
            stringArray = DATE_MASKS;
        } else if (column.getType().equals(DataType.TIMESTAMP.toString())) {
            stringArray = TIMESTAMP_MASKS;
        } else {
            return;
        }
        int n2 = -1;
        while (iterator.hasNext()) {
            if (bl2) {
                iterator.next();
                bl2 = false;
                continue;
            }
            Object[] objectArray = iterator.next();
            String string = objectArray[n].toString();
            if (n2 != -1) {
                if (!this._dateValidator.validateData(column, string)) {
                    n2 = -1;
                    break;
                }
            } else {
                n2 = this.findValidFormat(string, column, stringArray);
            }
            if (n2 == -1) continue;
            column.setFormat(stringArray[n2]);
            return;
        }
    }

    public boolean isNumber(String string, Column column, boolean bl) {
        String string2 = "";
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this._fmt.parse(string.toString(), parsePosition);
            if (number == null) {
                return false;
            }
            string2 = "" + number.doubleValue();
            if (parsePosition.getIndex() < string.length()) {
                return false;
            }
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            BigDecimal bigDecimal = new BigDecimal(string2);
            if (bl && bigDecimal.scale() == 0 && bigDecimal.precision() > 1 && string.startsWith("0")) {
                return false;
            }
            column.setType(DataType.NUMBER.toString());
            column.setPrecision(bigDecimal.precision());
            column.setScale(bigDecimal.scale());
        }
        catch (Exception exception) {
            return false;
        }
        return string2.length() != 0;
    }

    public void temporalInit() {
        this._formatIndex = 0;
        this._temporalType = null;
        this._format = null;
    }

    public boolean isTemporal(String string, Column column) {
        try {
            Matcher matcher = _uriPattern.matcher(string);
            if (matcher.find()) {
                return false;
            }
            boolean bl = false;
            if (this._temporalType == null) {
                if (string.contains(":")) {
                    bl = true;
                }
                if (string.contains("-") || string.contains("/") || bl) {
                    this._temporalType = DataType.DATE.toString();
                    column.setType(this._temporalType);
                    this._formatIndex = this.findValidFormat(string, column, DATE_MASKS);
                    this._format = DATE_MASKS[this._formatIndex];
                    column.setFormat(this._format);
                    if (this._formatIndex != -1) {
                        return true;
                    }
                }
                if (!bl) {
                    return false;
                }
                this._temporalType = DataType.TIMESTAMP.toString();
                column.setType(this._temporalType);
                this._formatIndex = this.findValidFormat(string, column, TIMESTAMP_MASKS);
                this._format = TIMESTAMP_MASKS[this._formatIndex];
                column.setFormat(this._format);
                return this._formatIndex != -1;
            }
            column.setType(this._temporalType);
            column.setFormat(this._format);
            return this._dateValidator.validateData(column, string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int findValidFormat(String string, Column column, String[] stringArray) {
        int n = 0;
        for (String string2 : stringArray) {
            column.setFormat(string2);
            if (this._dateValidator.validateData(column, string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

