/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.raptor.controls.display.chart.AbstractActionPanel;
import oracle.dbtools.raptor.controls.display.chart.AbstractLayoutPanel;
import oracle.dbtools.raptor.controls.display.chart.ChartArb;
import oracle.dbtools.raptor.controls.display.chart.CurrencySymbol;
import oracle.dbtools.raptor.controls.display.chart.EnumProperty;
import oracle.dbtools.raptor.controls.display.chart.NegativeNumberFormat;
import oracle.dbtools.raptor.controls.display.chart.NumberFormats;
import oracle.dbtools.raptor.controls.display.chart.NumberType;
import oracle.dbtools.raptor.controls.display.chart.ScaleFactor;

class NumberFormatsPanel
extends AbstractActionPanel<NumberFormats> {
    private JLabel numberTypeLabel = new JLabel(ChartArb.getString("NUMBER_TYPE_LABEL"));
    private JLabel decimalPlacesLabel;
    private JLabel scaleFactorLabel;
    private JLabel currencySymbolLabel;
    private JLabel negativeNumbersLabel;
    private JComboBox numberTypeCombo = new JComboBox<Object>(this.enumLabels(NumberType.values()));
    private JSpinner decPlacesSpinner;
    private JComboBox scaleFactorCombo;
    private JComboBox currencySymbolCombo;
    private JComboBox negativeNumbersCombo;

    NumberFormatsPanel() {
        super(4);
        this.decimalPlacesLabel = new JLabel(ChartArb.getString("DECIMAL_PLACES_LABEL"));
        this.decPlacesSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
        this.scaleFactorLabel = new JLabel(ChartArb.getString("SCALE_FACTOR_LABEL"));
        this.scaleFactorCombo = new JComboBox<Object>(this.enumLabels(ScaleFactor.values()));
        this.currencySymbolLabel = new JLabel(ChartArb.getString("CURRENCY_SYMBOL_LABEL"));
        this.currencySymbolCombo = new JComboBox<Object>(this.enumLabels(CurrencySymbol.values()));
        this.negativeNumbersLabel = new JLabel(ChartArb.getString("NEGATIVE_NUMBERS_LABEL"));
        this.negativeNumbersCombo = new JComboBox<Object>(this.enumLabels(NegativeNumberFormat.values()));
        this.addComponent(this.numberTypeLabel, 0, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.numberTypeCombo, 0, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(this.decimalPlacesLabel, 1, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.decPlacesSpinner, 1, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(this.scaleFactorLabel, 2, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.scaleFactorCombo, 2, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(this.currencySymbolLabel, 4, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.currencySymbolCombo, 4, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.addComponent(this.negativeNumbersLabel, 5, 0, 0, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.RIGHT);
        this.addComponent(this.negativeNumbersCombo, 5, 1, 1, AbstractLayoutPanel.SizeToFit.NEITHER, AbstractLayoutPanel.Align.LEFT);
        this.numberTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberFormatsPanel.this.updateEnabled();
            }
        });
    }

    @Override
    void setValue(NumberFormats numberFormats) {
        this.numberTypeCombo.setSelectedItem(numberFormats.numberType().label());
        this.decPlacesSpinner.setValue(numberFormats.decimalPlaces());
        this.scaleFactorCombo.setSelectedItem(numberFormats.scaleFactor().label());
        this.currencySymbolCombo.setSelectedItem(numberFormats.currencySymbol().label());
        this.negativeNumbersCombo.setSelectedItem(numberFormats.negativeNumberFormat().label());
        this.updateEnabled();
    }

    @Override
    NumberFormats value() {
        return new NumberFormats(NumberType.values()[this.numberTypeCombo.getSelectedIndex()], (Integer)this.decPlacesSpinner.getValue(), ScaleFactor.values()[this.scaleFactorCombo.getSelectedIndex()], NegativeNumberFormat.values()[this.negativeNumbersCombo.getSelectedIndex()], CurrencySymbol.values()[this.currencySymbolCombo.getSelectedIndex()]);
    }

    @Override
    String title() {
        return ChartArb.getString("EDIT_NUMBER_FORMATS");
    }

    private void updateEnabled() {
        NumberType numberType = NumberType.values()[this.numberTypeCombo.getSelectedIndex()];
        boolean bl = numberType == NumberType.CURRENCY;
        boolean bl2 = numberType != NumberType.PERCENT;
        this.currencySymbolLabel.setEnabled(bl);
        this.currencySymbolCombo.setEnabled(bl);
        this.scaleFactorLabel.setEnabled(bl2);
        this.scaleFactorCombo.setEnabled(bl2);
        this.negativeNumbersLabel.setEnabled(bl2);
        this.negativeNumbersCombo.setEnabled(bl2);
    }

    private Object[] enumLabels(EnumProperty[] enumPropertyArray) {
        Object[] objectArray = new String[enumPropertyArray.length];
        for (int i = 0; i < enumPropertyArray.length; ++i) {
            objectArray[i] = enumPropertyArray[i].label();
        }
        return objectArray;
    }
}

